@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
 * @property functionAlias A function alias, used when the type of the item is Function
 */
public data class ApplicationInsightsComponentAnalyticsItemPropertiesResponse(
    public val functionAlias: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ApplicationInsightsComponentAnalyticsItemPropertiesResponse):
            ApplicationInsightsComponentAnalyticsItemPropertiesResponse =
            ApplicationInsightsComponentAnalyticsItemPropertiesResponse(
                functionAlias = javaType.functionAlias().map({ args0 -> args0 }).orElse(null),
            )
    }
}
