@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
 * @property minFailingPeriodsToAlert The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods. Default value is 1
 * @property numberOfEvaluationPeriods The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points. Default value is 1
 */
public data class ConditionResponseFailingPeriods(
    public val minFailingPeriodsToAlert: Double? = null,
    public val numberOfEvaluationPeriods: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ConditionResponseFailingPeriods):
            ConditionResponseFailingPeriods = ConditionResponseFailingPeriods(
            minFailingPeriodsToAlert = javaType.minFailingPeriodsToAlert().map({ args0 -> args0 }).orElse(null),
            numberOfEvaluationPeriods = javaType.numberOfEvaluationPeriods().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
