@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An Activity Log Alert rule resource.
 * @property actions The actions that will activate when the condition is met.
 * @property condition The condition that will cause this alert to activate.
 * @property description A description of this Activity Log Alert rule.
 * @property enabled Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated.
 * @property id The resource Id.
 * @property location The location of the resource. Azure Activity Log Alert rules are supported on Global, West Europe and North Europe regions.
 * @property name The name of the resource.
 * @property scopes A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource IDs that fall under one of these prefixes. This list must include at least one item.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 */
public data class GetActivityLogAlertResult(
    public val actions: ActionListResponse,
    public val condition: AlertRuleAllOfConditionResponse,
    public val description: String? = null,
    public val enabled: Boolean? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val scopes: List<String>,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetActivityLogAlertResult):
            GetActivityLogAlertResult = GetActivityLogAlertResult(
            actions = javaType.actions().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.ActionListResponse.Companion.toKotlin(args0)
            }),
            condition = javaType.condition().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.AlertRuleAllOfConditionResponse.Companion.toKotlin(args0)
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            scopes = javaType.scopes().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
