@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Definition of ARM tracked top level resource.
 * @property configurationAccess The endpoint used by clients to access their configuration.
 * @property description Description of the data collection endpoint.
 * @property etag Resource entity tag (ETag).
 * @property failoverConfiguration Failover configuration on this endpoint. This property is READ-ONLY.
 * @property id Fully qualified ID of the resource.
 * @property identity Managed service identity of the resource.
 * @property immutableId The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
 * @property kind The kind of the resource.
 * @property location The geo-location where the resource lives.
 * @property logsIngestion The endpoint used by clients to ingest logs.
 * @property metadata Metadata for the resource. This property is READ-ONLY.
 * @property metricsIngestion The endpoint used by clients to ingest metrics.
 * @property name The name of the resource.
 * @property networkAcls Network access control rules for the endpoints.
 * @property privateLinkScopedResources List of Azure Monitor Private Link Scope Resources to which this data collection endpoint resource is associated. This property is READ-ONLY.
 * @property provisioningState The resource provisioning state. This property is READ-ONLY.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The type of the resource.
 */
public data class GetDataCollectionEndpointResult(
    public val configurationAccess: DataCollectionEndpointResponseConfigurationAccess? = null,
    public val description: String? = null,
    public val etag: String,
    public val failoverConfiguration: DataCollectionEndpointResponseFailoverConfiguration,
    public val id: String,
    public val identity: DataCollectionEndpointResourceResponseIdentity? = null,
    public val immutableId: String? = null,
    public val kind: String? = null,
    public val location: String,
    public val logsIngestion: DataCollectionEndpointResponseLogsIngestion? = null,
    public val metadata: DataCollectionEndpointResponseMetadata,
    public val metricsIngestion: DataCollectionEndpointResponseMetricsIngestion? = null,
    public val name: String,
    public val networkAcls: DataCollectionEndpointResponseNetworkAcls? = null,
    public val privateLinkScopedResources: List<PrivateLinkScopedResourceResponse>,
    public val provisioningState: String,
    public val systemData: DataCollectionEndpointResourceResponseSystemData,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetDataCollectionEndpointResult):
            GetDataCollectionEndpointResult = GetDataCollectionEndpointResult(
            configurationAccess = javaType.configurationAccess().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseConfigurationAccess.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            failoverConfiguration = javaType.failoverConfiguration().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseFailoverConfiguration.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResourceResponseIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            immutableId = javaType.immutableId().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            logsIngestion = javaType.logsIngestion().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseLogsIngestion.Companion.toKotlin(args0)
                })
            }).orElse(null),
            metadata = javaType.metadata().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseMetadata.Companion.toKotlin(args0)
            }),
            metricsIngestion = javaType.metricsIngestion().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseMetricsIngestion.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            networkAcls = javaType.networkAcls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseNetworkAcls.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkScopedResources = javaType.privateLinkScopedResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.PrivateLinkScopedResourceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResourceResponseSystemData.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
