@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The metric alert resource.
 * @property actions the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
 * @property autoMitigate the flag that indicates whether the alert should be auto resolved or not. The default is true.
 * @property criteria defines the specific alert criteria information.
 * @property description the description of the metric alert that will be included in the alert email.
 * @property enabled the flag that indicates whether the metric alert is enabled.
 * @property evaluationFrequency how often the metric alert is evaluated represented in ISO 8601 duration format.
 * @property id Azure resource Id
 * @property isMigrated the value indicating whether this alert rule is migrated.
 * @property lastUpdatedTime Last time the rule was updated in ISO8601 format.
 * @property location Resource location
 * @property name Azure resource name
 * @property scopes the list of resource id's that this metric alert is scoped to.
 * @property severity Alert severity {0, 1, 2, 3, 4}
 * @property tags Resource tags
 * @property targetResourceRegion the region of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
 * @property targetResourceType the resource type of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
 * @property type Azure resource type
 * @property windowSize the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
 */
public data class GetMetricAlertResult(
    public val actions: List<MetricAlertActionResponse>? = null,
    public val autoMitigate: Boolean? = null,
    public val criteria: Any,
    public val description: String? = null,
    public val enabled: Boolean,
    public val evaluationFrequency: String,
    public val id: String,
    public val isMigrated: Boolean,
    public val lastUpdatedTime: String,
    public val location: String,
    public val name: String,
    public val scopes: List<String>,
    public val severity: Int,
    public val tags: Map<String, String>? = null,
    public val targetResourceRegion: String? = null,
    public val targetResourceType: String? = null,
    public val type: String,
    public val windowSize: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetMetricAlertResult):
            GetMetricAlertResult = GetMetricAlertResult(
            actions = javaType.actions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.MetricAlertActionResponse.Companion.toKotlin(args0)
                })
            }),
            autoMitigate = javaType.autoMitigate().map({ args0 -> args0 }).orElse(null),
            criteria = javaType.criteria(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
            evaluationFrequency = javaType.evaluationFrequency(),
            id = javaType.id(),
            isMigrated = javaType.isMigrated(),
            lastUpdatedTime = javaType.lastUpdatedTime(),
            location = javaType.location(),
            name = javaType.name(),
            scopes = javaType.scopes().map({ args0 -> args0 }),
            severity = javaType.severity(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceRegion = javaType.targetResourceRegion().map({ args0 -> args0 }).orElse(null),
            targetResourceType = javaType.targetResourceType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            windowSize = javaType.windowSize(),
        )
    }
}
