@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A workbook definition.
 * @property category Workbook category, as defined by the user at creation time.
 * @property description The description of the workbook.
 * @property displayName The user-defined name (display name) of the workbook.
 * @property etag Resource etag
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Identity used for BYOS
 * @property kind The kind of workbook. Only valid value is shared.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property revision The unique revision id for this workbook definition
 * @property serializedData Configuration of this particular workbook. Configuration data is a string containing valid JSON
 * @property sourceId ResourceId for a source resource.
 * @property storageUri The resourceId to the storage account when bring your own storage is used
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property timeModified Date and time in UTC of the last modification that was made to this workbook definition.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property userId Unique user id of the specific user that owns this workbook.
 * @property version Workbook schema version format, like 'Notebook/1.0', which should match the workbook in serializedData
 */
public data class GetWorkbookResult(
    public val category: String,
    public val description: String? = null,
    public val displayName: String,
    public val etag: String? = null,
    public val id: String,
    public val identity: WorkbookResourceResponseIdentity? = null,
    public val kind: String? = null,
    public val location: String,
    public val name: String,
    public val revision: String,
    public val serializedData: String,
    public val sourceId: String? = null,
    public val storageUri: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val timeModified: String,
    public val type: String,
    public val userId: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetWorkbookResult):
            GetWorkbookResult = GetWorkbookResult(
            category = javaType.category(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WorkbookResourceResponseIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            revision = javaType.revision(),
            serializedData = javaType.serializedData(),
            sourceId = javaType.sourceId().map({ args0 -> args0 }).orElse(null),
            storageUri = javaType.storageUri().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeModified = javaType.timeModified(),
            type = javaType.type(),
            userId = javaType.userId(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
