@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Log Analytics destination.
 * @property name A friendly name for the destination.
 * This name should be unique across all destinations (regardless of type) within the data collection rule.
 * @property workspaceId The Customer ID of the Log Analytics workspace.
 * @property workspaceResourceId The resource ID of the Log Analytics workspace.
 */
public data class LogAnalyticsDestinationResponse(
    public val name: String? = null,
    public val workspaceId: String,
    public val workspaceResourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.LogAnalyticsDestinationResponse):
            LogAnalyticsDestinationResponse = LogAnalyticsDestinationResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            workspaceId = javaType.workspaceId(),
            workspaceResourceId = javaType.workspaceResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
