@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Definition of which custom log files will be collected by this data collection rule
 * @property filePatterns File Patterns where the log files are located
 * @property format The data format of the log files
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property settings The log files specific settings.
 * @property streams List of streams that this data source will be sent to.
 * A stream indicates what schema will be used for this data source
 */
public data class LogFilesDataSourceResponse(
    public val filePatterns: List<String>,
    public val format: String,
    public val name: String? = null,
    public val settings: LogFilesDataSourceResponseSettings? = null,
    public val streams: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.LogFilesDataSourceResponse):
            LogFilesDataSourceResponse = LogFilesDataSourceResponse(
            filePatterns = javaType.filePatterns().map({ args0 -> args0 }),
            format = javaType.format(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            settings = javaType.settings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.LogFilesDataSourceResponseSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            streams = javaType.streams().map({ args0 -> args0 }),
        )
    }
}
