@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A logic app receiver.
 * @property callbackUrl The callback url where http request sent to.
 * @property name The name of the logic app receiver. Names must be unique across all receivers within an action group.
 * @property resourceId The azure resource id of the logic app receiver.
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 */
public data class LogicAppReceiverResponse(
    public val callbackUrl: String,
    public val name: String,
    public val resourceId: String,
    public val useCommonAlertSchema: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.LogicAppReceiverResponse):
            LogicAppReceiverResponse = LogicAppReceiverResponse(
            callbackUrl = javaType.callbackUrl(),
            name = javaType.name(),
            resourceId = javaType.resourceId(),
            useCommonAlertSchema = javaType.useCommonAlertSchema().map({ args0 -> args0 }).orElse(null),
        )
    }
}
