@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An alert action.
 * @property actionGroupId the id of the action group to use.
 * @property webHookProperties This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
 */
public data class MetricAlertActionResponse(
    public val actionGroupId: String? = null,
    public val webHookProperties: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.MetricAlertActionResponse):
            MetricAlertActionResponse = MetricAlertActionResponse(
            actionGroupId = javaType.actionGroupId().map({ args0 -> args0 }).orElse(null),
            webHookProperties = javaType.webHookProperties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
