@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies a metric dimension.
 * @property name Name of the dimension.
 * @property operator the dimension operator. Only 'Include' and 'Exclude' are supported
 * @property values list of dimension values.
 */
public data class MetricDimensionResponse(
    public val name: String,
    public val `operator`: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.MetricDimensionResponse):
            MetricDimensionResponse = MetricDimensionResponse(
            name = javaType.name(),
            `operator` = javaType.`operator`(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
