@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The trigger that results in a scaling action.
 * @property dimensions List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
 * @property dividePerInstance a value indicating whether metric should divide per instance.
 * @property metricName the name of the metric that defines what the rule monitors.
 * @property metricNamespace the namespace of the metric that defines what the rule monitors.
 * @property metricResourceLocation the location of the resource the rule monitors.
 * @property metricResourceUri the resource identifier of the resource the rule monitors.
 * @property operator the operator that is used to compare the metric data and the threshold.
 * @property statistic the metric statistic type. How the metrics from multiple instances are combined.
 * @property threshold the threshold of the metric that triggers the scale action.
 * @property timeAggregation time aggregation type. How the data that is collected should be combined over time. The default value is Average.
 * @property timeGrain the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
 * @property timeWindow the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
 */
public data class MetricTriggerResponse(
    public val dimensions: List<ScaleRuleMetricDimensionResponse>? = null,
    public val dividePerInstance: Boolean? = null,
    public val metricName: String,
    public val metricNamespace: String? = null,
    public val metricResourceLocation: String? = null,
    public val metricResourceUri: String,
    public val `operator`: String,
    public val statistic: String,
    public val threshold: Double,
    public val timeAggregation: String,
    public val timeGrain: String,
    public val timeWindow: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.MetricTriggerResponse):
            MetricTriggerResponse = MetricTriggerResponse(
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.ScaleRuleMetricDimensionResponse.Companion.toKotlin(args0)
                })
            }),
            dividePerInstance = javaType.dividePerInstance().map({ args0 -> args0 }).orElse(null),
            metricName = javaType.metricName(),
            metricNamespace = javaType.metricNamespace().map({ args0 -> args0 }).orElse(null),
            metricResourceLocation = javaType.metricResourceLocation().map({ args0 -> args0 }).orElse(null),
            metricResourceUri = javaType.metricResourceUri(),
            `operator` = javaType.`operator`(),
            statistic = javaType.statistic(),
            threshold = javaType.threshold(),
            timeAggregation = javaType.timeAggregation(),
            timeGrain = javaType.timeGrain(),
            timeWindow = javaType.timeWindow(),
        )
    }
}
