@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the action to send email when the rule condition is evaluated. The discriminator is always RuleEmailAction in this case.
 * @property customEmails the list of administrator's custom email addresses to notify of the activation of the alert.
 * @property odataType specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'.
 * @property sendToServiceOwners Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
 */
public data class RuleEmailActionResponse(
    public val customEmails: List<String>? = null,
    public val odataType: String,
    public val sendToServiceOwners: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.RuleEmailActionResponse):
            RuleEmailActionResponse = RuleEmailActionResponse(
            customEmails = javaType.customEmails().map({ args0 -> args0 }),
            odataType = javaType.odataType(),
            sendToServiceOwners = javaType.sendToServiceOwners().map({ args0 -> args0 }).orElse(null),
        )
    }
}
