@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Specifies the action to post to service when the rule condition is evaluated. The discriminator is always RuleWebhookAction in this case.
 * @property odataType specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'.
 * @property properties the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
 * @property serviceUri the service uri to Post the notification when the alert activates or resolves.
 */
public data class RuleWebhookActionResponse(
    public val odataType: String,
    public val properties: Map<String, String>? = null,
    public val serviceUri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.RuleWebhookActionResponse):
            RuleWebhookActionResponse = RuleWebhookActionResponse(
            odataType = javaType.odataType(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            serviceUri = javaType.serviceUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
