@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * A rule condition based on a metric crossing a threshold.
 * @property dataSource the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
 * @property odataType specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'.
 * @property operator the operator used to compare the data and the threshold.
 * @property threshold the threshold value that activates the alert.
 * @property timeAggregation the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric.
 * @property windowSize the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
 */
public data class ThresholdRuleConditionResponse(
    public val dataSource:
    Either<RuleManagementEventDataSourceResponse, RuleMetricDataSourceResponse>? = null,
    public val odataType: String,
    public val `operator`: String,
    public val threshold: Double,
    public val timeAggregation: String? = null,
    public val windowSize: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ThresholdRuleConditionResponse):
            ThresholdRuleConditionResponse = ThresholdRuleConditionResponse(
            dataSource = javaType.dataSource().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.RuleManagementEventDataSourceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.RuleMetricDataSourceResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            odataType = javaType.odataType(),
            `operator` = javaType.`operator`(),
            threshold = javaType.threshold(),
            timeAggregation = javaType.timeAggregation().map({ args0 -> args0 }).orElse(null),
            windowSize = javaType.windowSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
