@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An XML configuration specification for a WebTest.
 * @property webTest The XML specification of a WebTest to run against an application.
 */
public data class WebTestPropertiesResponseConfiguration(
    public val webTest: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.WebTestPropertiesResponseConfiguration):
            WebTestPropertiesResponseConfiguration = WebTestPropertiesResponseConfiguration(
            webTest = javaType.webTest().map({ args0 -> args0 }).orElse(null),
        )
    }
}
