@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin

import com.pulumi.azurenative.integrationspaces.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.TrackingDataStoreResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.TrackingDataStoreResponse.Companion.toKotlin as trackingDataStoreResponseToKotlin

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource =
            com.pulumi.azurenative.integrationspaces.Application(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Application(builtJavaResource)
    }
}

/**
 * An integration application under space.
 * Azure REST API version: 2023-11-14-preview.
 * ## Example Usage
 * ### CreateOrUpdateApplication
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.IntegrationSpaces.Application("application", new()
 *     {
 *         ApplicationName = "Application1",
 *         Description = "This is the user provided description of the application.",
 *         Location = "CentralUS",
 *         ResourceGroupName = "testrg",
 *         SpaceName = "Space1",
 *         Tags =
 *         {
 *             { "key1", "Value1" },
 *         },
 *         TrackingDataStores =
 *         {
 *             { "dataStoreName1", new AzureNative.IntegrationSpaces.Inputs.TrackingDataStoreArgs
 *             {
 *                 DataStoreIngestionUri = "https://ingest-someClusterName.someRegionName.kusto.windows.net",
 *                 DataStoreResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Kusto/Clusters/cluster1",
 *                 DataStoreUri = "https://someClusterName.someRegionName.kusto.windows.net",
 *                 DatabaseName = "testDatabase1",
 *             } },
 *             { "dataStoreName2", new AzureNative.IntegrationSpaces.Inputs.TrackingDataStoreArgs
 *             {
 *                 DataStoreIngestionUri = "https://ingest-someClusterName.someRegionName.kusto.windows.net",
 *                 DataStoreResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Kusto/Clusters/cluster1",
 *                 DataStoreUri = "https://someClusterName.someRegionName.kusto.windows.net",
 *                 DatabaseName = "testDatabase1",
 *             } },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/integrationspaces/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := integrationspaces.NewApplication(ctx, "application", &integrationspaces.ApplicationArgs{
 * 			ApplicationName:   pulumi.String("Application1"),
 * 			Description:       pulumi.String("This is the user provided description of the application."),
 * 			Location:          pulumi.String("CentralUS"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			SpaceName:         pulumi.String("Space1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("Value1"),
 * 			},
 * 			TrackingDataStores: integrationspaces.TrackingDataStoreMap{
 * 				"dataStoreName1": &integrationspaces.TrackingDataStoreArgs{
 * 					DataStoreIngestionUri: pulumi.String("https://ingest-someClusterName.someRegionName.kusto.windows.net"),
 * 					DataStoreResourceId:   pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Kusto/Clusters/cluster1"),
 * 					DataStoreUri:          pulumi.String("https://someClusterName.someRegionName.kusto.windows.net"),
 * 					DatabaseName:          pulumi.String("testDatabase1"),
 * 				},
 * 				"dataStoreName2": &integrationspaces.TrackingDataStoreArgs{
 * 					DataStoreIngestionUri: pulumi.String("https://ingest-someClusterName.someRegionName.kusto.windows.net"),
 * 					DataStoreResourceId:   pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Kusto/Clusters/cluster1"),
 * 					DataStoreUri:          pulumi.String("https://someClusterName.someRegionName.kusto.windows.net"),
 * 					DatabaseName:          pulumi.String("testDatabase1"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.integrationspaces.Application;
 * import com.pulumi.azurenative.integrationspaces.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .applicationName("Application1")
 *             .description("This is the user provided description of the application.")
 *             .location("CentralUS")
 *             .resourceGroupName("testrg")
 *             .spaceName("Space1")
 *             .tags(Map.of("key1", "Value1"))
 *             .trackingDataStores(Map.ofEntries(
 *                 Map.entry("dataStoreName1", Map.ofEntries(
 *                     Map.entry("dataStoreIngestionUri", "https://ingest-someClusterName.someRegionName.kusto.windows.net"),
 *                     Map.entry("dataStoreResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Kusto/Clusters/cluster1"),
 *                     Map.entry("dataStoreUri", "https://someClusterName.someRegionName.kusto.windows.net"),
 *                     Map.entry("databaseName", "testDatabase1")
 *                 )),
 *                 Map.entry("dataStoreName2", Map.ofEntries(
 *                     Map.entry("dataStoreIngestionUri", "https://ingest-someClusterName.someRegionName.kusto.windows.net"),
 *                     Map.entry("dataStoreResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Kusto/Clusters/cluster1"),
 *                     Map.entry("dataStoreUri", "https://someClusterName.someRegionName.kusto.windows.net"),
 *                     Map.entry("databaseName", "testDatabase1")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:integrationspaces:Application Application1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}
 * ```
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.azurenative.integrationspaces.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * The description of the resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The tracking data stores.
     */
    public val trackingDataStores: Output<Map<String, TrackingDataStoreResponse>>
        get() = javaResource.trackingDataStores().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        trackingDataStoreResponseToKotlin(args0)
                    }),
                )
            }).toMap()
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.integrationspaces.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.azurenative.integrationspaces.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit):
    Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
