@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.inputs

import com.pulumi.azurenative.integrationspaces.inputs.BusinessProcessIdentifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of business process identifier.
 * @property propertyName The property name of the business process identifier.
 * @property propertyType The property type of the business process identifier.
 */
public data class BusinessProcessIdentifierArgs(
    public val propertyName: Output<String>? = null,
    public val propertyType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.integrationspaces.inputs.BusinessProcessIdentifierArgs> {
    override fun toJava():
        com.pulumi.azurenative.integrationspaces.inputs.BusinessProcessIdentifierArgs =
        com.pulumi.azurenative.integrationspaces.inputs.BusinessProcessIdentifierArgs.builder()
            .propertyName(propertyName?.applyValue({ args0 -> args0 }))
            .propertyType(propertyType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BusinessProcessIdentifierArgs].
 */
@PulumiTagMarker
public class BusinessProcessIdentifierArgsBuilder internal constructor() {
    private var propertyName: Output<String>? = null

    private var propertyType: Output<String>? = null

    /**
     * @param value The property name of the business process identifier.
     */
    @JvmName("pwwmyekusbuixumd")
    public suspend fun propertyName(`value`: Output<String>) {
        this.propertyName = value
    }

    /**
     * @param value The property type of the business process identifier.
     */
    @JvmName("sjbmylclvpkhcqxg")
    public suspend fun propertyType(`value`: Output<String>) {
        this.propertyType = value
    }

    /**
     * @param value The property name of the business process identifier.
     */
    @JvmName("rugvtjfhccxktkyw")
    public suspend fun propertyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyName = mapped
    }

    /**
     * @param value The property type of the business process identifier.
     */
    @JvmName("dxpubfopwnfwfkwm")
    public suspend fun propertyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyType = mapped
    }

    internal fun build(): BusinessProcessIdentifierArgs = BusinessProcessIdentifierArgs(
        propertyName = propertyName,
        propertyType = propertyType,
    )
}
