@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.inputs

import com.pulumi.azurenative.integrationspaces.inputs.GetApplicationResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationName The name of the Application
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the application resource.
 * @property spaceName The name of the space
 */
public data class GetApplicationResourcePlainArgs(
    public val applicationName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
    public val spaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.integrationspaces.inputs.GetApplicationResourcePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.integrationspaces.inputs.GetApplicationResourcePlainArgs =
        com.pulumi.azurenative.integrationspaces.inputs.GetApplicationResourcePlainArgs.builder()
            .applicationName(applicationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .spaceName(spaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationResourcePlainArgs].
 */
@PulumiTagMarker
public class GetApplicationResourcePlainArgsBuilder internal constructor() {
    private var applicationName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var spaceName: String? = null

    /**
     * @param value The name of the Application
     */
    @JvmName("xotahjfpwsddprgm")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hxatcmecfljopisq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the application resource.
     */
    @JvmName("yukgrpsjuegioaky")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value The name of the space
     */
    @JvmName("jlfwmqjelggtgomd")
    public suspend fun spaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.spaceName = mapped
    }

    internal fun build(): GetApplicationResourcePlainArgs = GetApplicationResourcePlainArgs(
        applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        spaceName = spaceName ?: throw PulumiNullFieldException("spaceName"),
    )
}
