@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.inputs

import com.pulumi.azurenative.integrationspaces.inputs.TrackingDataStoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of tracking data store.
 * @property dataStoreIngestionUri The data store ingestion URI.
 * @property dataStoreResourceId The data store resource id.
 * @property dataStoreUri The data store URI.
 * @property databaseName The database name.
 */
public data class TrackingDataStoreArgs(
    public val dataStoreIngestionUri: Output<String>,
    public val dataStoreResourceId: Output<String>,
    public val dataStoreUri: Output<String>,
    public val databaseName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.integrationspaces.inputs.TrackingDataStoreArgs> {
    override fun toJava(): com.pulumi.azurenative.integrationspaces.inputs.TrackingDataStoreArgs =
        com.pulumi.azurenative.integrationspaces.inputs.TrackingDataStoreArgs.builder()
            .dataStoreIngestionUri(dataStoreIngestionUri.applyValue({ args0 -> args0 }))
            .dataStoreResourceId(dataStoreResourceId.applyValue({ args0 -> args0 }))
            .dataStoreUri(dataStoreUri.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrackingDataStoreArgs].
 */
@PulumiTagMarker
public class TrackingDataStoreArgsBuilder internal constructor() {
    private var dataStoreIngestionUri: Output<String>? = null

    private var dataStoreResourceId: Output<String>? = null

    private var dataStoreUri: Output<String>? = null

    private var databaseName: Output<String>? = null

    /**
     * @param value The data store ingestion URI.
     */
    @JvmName("vixpqbwseexutrak")
    public suspend fun dataStoreIngestionUri(`value`: Output<String>) {
        this.dataStoreIngestionUri = value
    }

    /**
     * @param value The data store resource id.
     */
    @JvmName("ivlshowpmkqhntrx")
    public suspend fun dataStoreResourceId(`value`: Output<String>) {
        this.dataStoreResourceId = value
    }

    /**
     * @param value The data store URI.
     */
    @JvmName("icyjmldxlaiypgif")
    public suspend fun dataStoreUri(`value`: Output<String>) {
        this.dataStoreUri = value
    }

    /**
     * @param value The database name.
     */
    @JvmName("iobydvetkbiqfwpy")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The data store ingestion URI.
     */
    @JvmName("tfipgidanwadwqpk")
    public suspend fun dataStoreIngestionUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStoreIngestionUri = mapped
    }

    /**
     * @param value The data store resource id.
     */
    @JvmName("npbuxuwmvsrgoeod")
    public suspend fun dataStoreResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStoreResourceId = mapped
    }

    /**
     * @param value The data store URI.
     */
    @JvmName("khfwnmrotceflpqm")
    public suspend fun dataStoreUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStoreUri = mapped
    }

    /**
     * @param value The database name.
     */
    @JvmName("fusnkgutkubhyvwk")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    internal fun build(): TrackingDataStoreArgs = TrackingDataStoreArgs(
        dataStoreIngestionUri = dataStoreIngestionUri ?: throw
            PulumiNullFieldException("dataStoreIngestionUri"),
        dataStoreResourceId = dataStoreResourceId ?: throw PulumiNullFieldException("dataStoreResourceId"),
        dataStoreUri = dataStoreUri ?: throw PulumiNullFieldException("dataStoreUri"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
    )
}
