@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of business process mapping.
 * @property logicAppResourceId The logic app resource id.
 * @property operationName The operation name.
 * @property operationType The mapping item operation type of the business process.
 * @property workflowName The workflow name within the logic app.
 */
public data class BusinessProcessMappingItemResponse(
    public val logicAppResourceId: String? = null,
    public val operationName: String? = null,
    public val operationType: String? = null,
    public val workflowName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.BusinessProcessMappingItemResponse):
            BusinessProcessMappingItemResponse = BusinessProcessMappingItemResponse(
            logicAppResourceId = javaType.logicAppResourceId().map({ args0 -> args0 }).orElse(null),
            operationName = javaType.operationName().map({ args0 -> args0 }).orElse(null),
            operationType = javaType.operationType().map({ args0 -> args0 }).orElse(null),
            workflowName = javaType.workflowName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
