@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The business process reference.
 * @property name The business process name.
 * @property version The business process version.
 */
public data class BusinessProcessReferenceResponse(
    public val name: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.BusinessProcessReferenceResponse):
            BusinessProcessReferenceResponse = BusinessProcessReferenceResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
