@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The properties of business process stage.
 * @property description The description of the business stage.
 * @property properties The properties within the properties of the business process stage.
 * @property stagesBefore The property to keep track of stages before current in the business process stage.
 */
public data class BusinessProcessStageResponse(
    public val description: String? = null,
    public val properties: Map<String, String>? = null,
    public val stagesBefore: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.BusinessProcessStageResponse):
            BusinessProcessStageResponse = BusinessProcessStageResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            stagesBefore = javaType.stagesBefore().map({ args0 -> args0 }),
        )
    }
}
