@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The tracking correlation context.
 * @property operationName The operation name for correlation context.
 * @property operationType The operation type for correlation context.
 * @property propertyName The name of the correlation property.
 * @property value The template expression for correlation context property value.
 */
public data class TrackingCorrelationContextResponse(
    public val operationName: String? = null,
    public val operationType: String? = null,
    public val propertyName: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.TrackingCorrelationContextResponse):
            TrackingCorrelationContextResponse = TrackingCorrelationContextResponse(
            operationName = javaType.operationName().map({ args0 -> args0 }).orElse(null),
            operationType = javaType.operationType().map({ args0 -> args0 }).orElse(null),
            propertyName = javaType.propertyName().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
