@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of tracking data store.
 * @property dataStoreIngestionUri The data store ingestion URI.
 * @property dataStoreResourceId The data store resource id.
 * @property dataStoreUri The data store URI.
 * @property databaseName The database name.
 */
public data class TrackingDataStoreResponse(
    public val dataStoreIngestionUri: String,
    public val dataStoreResourceId: String,
    public val dataStoreUri: String,
    public val databaseName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.TrackingDataStoreResponse):
            TrackingDataStoreResponse = TrackingDataStoreResponse(
            dataStoreIngestionUri = javaType.dataStoreIngestionUri(),
            dataStoreResourceId = javaType.dataStoreResourceId(),
            dataStoreUri = javaType.dataStoreUri(),
            databaseName = javaType.databaseName(),
        )
    }
}
