@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The tracking profile for the business process
 * @property businessProcess The business process reference.
 * @property schema The tracking definition schema uri.
 * @property trackingDefinitions The tracking definitions.
 */
public data class TrackingProfileDefinitionResponse(
    public val businessProcess: BusinessProcessReferenceResponse? = null,
    public val schema: String? = null,
    public val trackingDefinitions: Map<String, FlowTrackingDefinitionResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.TrackingProfileDefinitionResponse):
            TrackingProfileDefinitionResponse = TrackingProfileDefinitionResponse(
            businessProcess = javaType.businessProcess().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.integrationspaces.kotlin.outputs.BusinessProcessReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            schema = javaType.schema().map({ args0 -> args0 }).orElse(null),
            trackingDefinitions = javaType.trackingDefinitions().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.integrationspaces.kotlin.outputs.FlowTrackingDefinitionResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
