@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.intune.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AndroidMAMPolicyByName].
 */
@PulumiTagMarker
public class AndroidMAMPolicyByNameResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AndroidMAMPolicyByNameArgs = AndroidMAMPolicyByNameArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AndroidMAMPolicyByNameArgsBuilder.() -> Unit) {
        val builder = AndroidMAMPolicyByNameArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AndroidMAMPolicyByName {
        val builtJavaResource =
            com.pulumi.azurenative.intune.AndroidMAMPolicyByName(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AndroidMAMPolicyByName(builtJavaResource)
    }
}

/**
 * Android Policy entity for Intune MAM.
 * Azure REST API version: 2015-01-14-preview. Prior API version in Azure Native 1.x: 2015-01-14-preview.
 * Other available API versions: 2015-01-14-privatepreview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:intune:AndroidMAMPolicyByName myresource1 /providers/Microsoft.Intune/locations/{hostName}/androidPolicies/{policyName}
 * ```
 */
public class AndroidMAMPolicyByName internal constructor(
    override val javaResource: com.pulumi.azurenative.intune.AndroidMAMPolicyByName,
) : KotlinCustomResource(javaResource, AndroidMAMPolicyByNameMapper) {
    public val accessRecheckOfflineTimeout: Output<String>?
        get() = javaResource.accessRecheckOfflineTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val accessRecheckOnlineTimeout: Output<String>?
        get() = javaResource.accessRecheckOnlineTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val appSharingFromLevel: Output<String>?
        get() = javaResource.appSharingFromLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val appSharingToLevel: Output<String>?
        get() = javaResource.appSharingToLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val authentication: Output<String>?
        get() = javaResource.authentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val clipboardSharingLevel: Output<String>?
        get() = javaResource.clipboardSharingLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val dataBackup: Output<String>?
        get() = javaResource.dataBackup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val deviceCompliance: Output<String>?
        get() = javaResource.deviceCompliance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val fileEncryption: Output<String>?
        get() = javaResource.fileEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val fileSharingSaveAs: Output<String>?
        get() = javaResource.fileSharingSaveAs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val friendlyName: Output<String>
        get() = javaResource.friendlyName().applyValue({ args0 -> args0 })

    public val groupStatus: Output<String>
        get() = javaResource.groupStatus().applyValue({ args0 -> args0 })

    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * Resource Location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val managedBrowser: Output<String>?
        get() = javaResource.managedBrowser().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val numOfApps: Output<Int>
        get() = javaResource.numOfApps().applyValue({ args0 -> args0 })

    public val offlineWipeTimeout: Output<String>?
        get() = javaResource.offlineWipeTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val pin: Output<String>?
        get() = javaResource.pin().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val pinNumRetry: Output<Int>?
        get() = javaResource.pinNumRetry().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val screenCapture: Output<String>?
        get() = javaResource.screenCapture().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AndroidMAMPolicyByNameMapper : ResourceMapper<AndroidMAMPolicyByName> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.intune.AndroidMAMPolicyByName::class == javaResource::class

    override fun map(javaResource: Resource): AndroidMAMPolicyByName =
        AndroidMAMPolicyByName(javaResource as com.pulumi.azurenative.intune.AndroidMAMPolicyByName)
}

/**
 * @see [AndroidMAMPolicyByName].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AndroidMAMPolicyByName].
 */
public suspend fun androidMAMPolicyByName(
    name: String,
    block: suspend AndroidMAMPolicyByNameResourceBuilder.() -> Unit,
): AndroidMAMPolicyByName {
    val builder = AndroidMAMPolicyByNameResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AndroidMAMPolicyByName].
 * @param name The _unique_ name of the resulting resource.
 */
public fun androidMAMPolicyByName(name: String): AndroidMAMPolicyByName {
    val builder = AndroidMAMPolicyByNameResourceBuilder()
    builder.name(name)
    return builder.build()
}
