@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.intune.kotlin

import com.pulumi.azurenative.intune.AndroidMAMPolicyByNameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Android Policy entity for Intune MAM.
 * Azure REST API version: 2015-01-14-preview. Prior API version in Azure Native 1.x: 2015-01-14-preview.
 * Other available API versions: 2015-01-14-privatepreview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:intune:AndroidMAMPolicyByName myresource1 /providers/Microsoft.Intune/locations/{hostName}/androidPolicies/{policyName}
 * ```
 * @property accessRecheckOfflineTimeout
 * @property accessRecheckOnlineTimeout
 * @property appSharingFromLevel
 * @property appSharingToLevel
 * @property authentication
 * @property clipboardSharingLevel
 * @property dataBackup
 * @property description
 * @property deviceCompliance
 * @property fileEncryption
 * @property fileSharingSaveAs
 * @property friendlyName
 * @property hostName Location hostName for the tenant
 * @property location Resource Location
 * @property managedBrowser
 * @property offlineWipeTimeout
 * @property pin
 * @property pinNumRetry
 * @property policyName Unique name for the policy
 * @property screenCapture
 * @property tags Resource Tags
 */
public data class AndroidMAMPolicyByNameArgs(
    public val accessRecheckOfflineTimeout: Output<String>? = null,
    public val accessRecheckOnlineTimeout: Output<String>? = null,
    public val appSharingFromLevel: Output<String>? = null,
    public val appSharingToLevel: Output<String>? = null,
    public val authentication: Output<String>? = null,
    public val clipboardSharingLevel: Output<String>? = null,
    public val dataBackup: Output<String>? = null,
    public val description: Output<String>? = null,
    public val deviceCompliance: Output<String>? = null,
    public val fileEncryption: Output<String>? = null,
    public val fileSharingSaveAs: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val hostName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedBrowser: Output<String>? = null,
    public val offlineWipeTimeout: Output<String>? = null,
    public val pin: Output<String>? = null,
    public val pinNumRetry: Output<Int>? = null,
    public val policyName: Output<String>? = null,
    public val screenCapture: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.intune.AndroidMAMPolicyByNameArgs> {
    override fun toJava(): com.pulumi.azurenative.intune.AndroidMAMPolicyByNameArgs =
        com.pulumi.azurenative.intune.AndroidMAMPolicyByNameArgs.builder()
            .accessRecheckOfflineTimeout(accessRecheckOfflineTimeout?.applyValue({ args0 -> args0 }))
            .accessRecheckOnlineTimeout(accessRecheckOnlineTimeout?.applyValue({ args0 -> args0 }))
            .appSharingFromLevel(appSharingFromLevel?.applyValue({ args0 -> args0 }))
            .appSharingToLevel(appSharingToLevel?.applyValue({ args0 -> args0 }))
            .authentication(authentication?.applyValue({ args0 -> args0 }))
            .clipboardSharingLevel(clipboardSharingLevel?.applyValue({ args0 -> args0 }))
            .dataBackup(dataBackup?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .deviceCompliance(deviceCompliance?.applyValue({ args0 -> args0 }))
            .fileEncryption(fileEncryption?.applyValue({ args0 -> args0 }))
            .fileSharingSaveAs(fileSharingSaveAs?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedBrowser(managedBrowser?.applyValue({ args0 -> args0 }))
            .offlineWipeTimeout(offlineWipeTimeout?.applyValue({ args0 -> args0 }))
            .pin(pin?.applyValue({ args0 -> args0 }))
            .pinNumRetry(pinNumRetry?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .screenCapture(screenCapture?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AndroidMAMPolicyByNameArgs].
 */
@PulumiTagMarker
public class AndroidMAMPolicyByNameArgsBuilder internal constructor() {
    private var accessRecheckOfflineTimeout: Output<String>? = null

    private var accessRecheckOnlineTimeout: Output<String>? = null

    private var appSharingFromLevel: Output<String>? = null

    private var appSharingToLevel: Output<String>? = null

    private var authentication: Output<String>? = null

    private var clipboardSharingLevel: Output<String>? = null

    private var dataBackup: Output<String>? = null

    private var description: Output<String>? = null

    private var deviceCompliance: Output<String>? = null

    private var fileEncryption: Output<String>? = null

    private var fileSharingSaveAs: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var hostName: Output<String>? = null

    private var location: Output<String>? = null

    private var managedBrowser: Output<String>? = null

    private var offlineWipeTimeout: Output<String>? = null

    private var pin: Output<String>? = null

    private var pinNumRetry: Output<Int>? = null

    private var policyName: Output<String>? = null

    private var screenCapture: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("esucsxvqpivdguwt")
    public suspend fun accessRecheckOfflineTimeout(`value`: Output<String>) {
        this.accessRecheckOfflineTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("ofnephircwuaxmir")
    public suspend fun accessRecheckOnlineTimeout(`value`: Output<String>) {
        this.accessRecheckOnlineTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("odpvnfxdnxsvmtii")
    public suspend fun appSharingFromLevel(`value`: Output<String>) {
        this.appSharingFromLevel = value
    }

    /**
     * @param value
     */
    @JvmName("ybtfascetcsitvff")
    public suspend fun appSharingToLevel(`value`: Output<String>) {
        this.appSharingToLevel = value
    }

    /**
     * @param value
     */
    @JvmName("cnyrhvrsttvctcfo")
    public suspend fun authentication(`value`: Output<String>) {
        this.authentication = value
    }

    /**
     * @param value
     */
    @JvmName("xajxkkccbtbkjeeb")
    public suspend fun clipboardSharingLevel(`value`: Output<String>) {
        this.clipboardSharingLevel = value
    }

    /**
     * @param value
     */
    @JvmName("assdtwjmifsopnba")
    public suspend fun dataBackup(`value`: Output<String>) {
        this.dataBackup = value
    }

    /**
     * @param value
     */
    @JvmName("waphujsnqtmakvef")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("mnvonpepxgkmkftt")
    public suspend fun deviceCompliance(`value`: Output<String>) {
        this.deviceCompliance = value
    }

    /**
     * @param value
     */
    @JvmName("riwusxhfepvhvxvd")
    public suspend fun fileEncryption(`value`: Output<String>) {
        this.fileEncryption = value
    }

    /**
     * @param value
     */
    @JvmName("vaawagfhbekpotwj")
    public suspend fun fileSharingSaveAs(`value`: Output<String>) {
        this.fileSharingSaveAs = value
    }

    /**
     * @param value
     */
    @JvmName("fmyoyrsvivfxokmx")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Location hostName for the tenant
     */
    @JvmName("tepxfpttlgqrhvdo")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Resource Location
     */
    @JvmName("ikqpovmqqynfeecu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value
     */
    @JvmName("onwbtdcgkovlqhem")
    public suspend fun managedBrowser(`value`: Output<String>) {
        this.managedBrowser = value
    }

    /**
     * @param value
     */
    @JvmName("gyjrvellqoncqtcj")
    public suspend fun offlineWipeTimeout(`value`: Output<String>) {
        this.offlineWipeTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("jgqievxrkykuwcrw")
    public suspend fun pin(`value`: Output<String>) {
        this.pin = value
    }

    /**
     * @param value
     */
    @JvmName("jmmibqlaxrsnrjyv")
    public suspend fun pinNumRetry(`value`: Output<Int>) {
        this.pinNumRetry = value
    }

    /**
     * @param value Unique name for the policy
     */
    @JvmName("lldkyleqnkpvnfbn")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value
     */
    @JvmName("hkqqftiufcwbfkvm")
    public suspend fun screenCapture(`value`: Output<String>) {
        this.screenCapture = value
    }

    /**
     * @param value Resource Tags
     */
    @JvmName("flasqtddqmxfsjnx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("ovyvogveclpwmooc")
    public suspend fun accessRecheckOfflineTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessRecheckOfflineTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("jbrbhjrdxwbdxyjk")
    public suspend fun accessRecheckOnlineTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessRecheckOnlineTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("vcmgtkbnwmhjqofe")
    public suspend fun appSharingFromLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSharingFromLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("aksnowwjofxpoajr")
    public suspend fun appSharingToLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSharingToLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("lrqxujrjjogqjnbq")
    public suspend fun authentication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value
     */
    @JvmName("karssworahakkqck")
    public suspend fun clipboardSharingLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clipboardSharingLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("rnapeomjdawthiwg")
    public suspend fun dataBackup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataBackup = mapped
    }

    /**
     * @param value
     */
    @JvmName("drgyxfhaqllopwhq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("pbbdlmpnplsehhia")
    public suspend fun deviceCompliance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceCompliance = mapped
    }

    /**
     * @param value
     */
    @JvmName("rsehpkmnqewrolqu")
    public suspend fun fileEncryption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileEncryption = mapped
    }

    /**
     * @param value
     */
    @JvmName("hwssviqdllpvnsiq")
    public suspend fun fileSharingSaveAs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSharingSaveAs = mapped
    }

    /**
     * @param value
     */
    @JvmName("xioeoxlbsvuawnjk")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Location hostName for the tenant
     */
    @JvmName("wvcasuiftsunqtad")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Resource Location
     */
    @JvmName("siuwxbeuisjiluyc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value
     */
    @JvmName("oqebpkgatapdytdr")
    public suspend fun managedBrowser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBrowser = mapped
    }

    /**
     * @param value
     */
    @JvmName("kgivtvnqmofscyhf")
    public suspend fun offlineWipeTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offlineWipeTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("moftbgbhkxpxfgsx")
    public suspend fun pin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pin = mapped
    }

    /**
     * @param value
     */
    @JvmName("bctckctwajguadco")
    public suspend fun pinNumRetry(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pinNumRetry = mapped
    }

    /**
     * @param value Unique name for the policy
     */
    @JvmName("wohlveeofydmdxhh")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("nktqmupbuvsdmuxn")
    public suspend fun screenCapture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.screenCapture = mapped
    }

    /**
     * @param value Resource Tags
     */
    @JvmName("uksnvhxumnvfqvtu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource Tags
     */
    @JvmName("dxcuqqednjgaclvr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AndroidMAMPolicyByNameArgs = AndroidMAMPolicyByNameArgs(
        accessRecheckOfflineTimeout = accessRecheckOfflineTimeout,
        accessRecheckOnlineTimeout = accessRecheckOnlineTimeout,
        appSharingFromLevel = appSharingFromLevel,
        appSharingToLevel = appSharingToLevel,
        authentication = authentication,
        clipboardSharingLevel = clipboardSharingLevel,
        dataBackup = dataBackup,
        description = description,
        deviceCompliance = deviceCompliance,
        fileEncryption = fileEncryption,
        fileSharingSaveAs = fileSharingSaveAs,
        friendlyName = friendlyName,
        hostName = hostName,
        location = location,
        managedBrowser = managedBrowser,
        offlineWipeTimeout = offlineWipeTimeout,
        pin = pin,
        pinNumRetry = pinNumRetry,
        policyName = policyName,
        screenCapture = screenCapture,
        tags = tags,
    )
}
