@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotcentral.kotlin.inputs

import com.pulumi.azurenative.iotcentral.inputs.SystemAssignedServiceIdentityArgs.builder
import com.pulumi.azurenative.iotcentral.kotlin.enums.SystemAssignedServiceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed service identity (either system assigned, or none)
 * @property type Type of managed service identity (either system assigned, or none).
 */
public data class SystemAssignedServiceIdentityArgs(
    public val type: Output<Either<String, SystemAssignedServiceIdentityType>>,
) : ConvertibleToJava<com.pulumi.azurenative.iotcentral.inputs.SystemAssignedServiceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.iotcentral.inputs.SystemAssignedServiceIdentityArgs =
        com.pulumi.azurenative.iotcentral.inputs.SystemAssignedServiceIdentityArgs.builder()
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SystemAssignedServiceIdentityArgs].
 */
@PulumiTagMarker
public class SystemAssignedServiceIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, SystemAssignedServiceIdentityType>>? = null

    /**
     * @param value Type of managed service identity (either system assigned, or none).
     */
    @JvmName("awjjwxivvadrbesn")
    public suspend fun type(`value`: Output<Either<String, SystemAssignedServiceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value Type of managed service identity (either system assigned, or none).
     */
    @JvmName("bhygydktejlptvdl")
    public suspend fun type(`value`: Either<String, SystemAssignedServiceIdentityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of managed service identity (either system assigned, or none).
     */
    @JvmName("nqnyklxqnwepaxxx")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SystemAssignedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of managed service identity (either system assigned, or none).
     */
    @JvmName("rtvmlhbvvayghwpq")
    public fun type(`value`: SystemAssignedServiceIdentityType) {
        val toBeMapped = Either.ofRight<String, SystemAssignedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SystemAssignedServiceIdentityArgs = SystemAssignedServiceIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
