@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin

import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.DatasetPropertyKeyResponse
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.DatasetPropertyKeyResponse.Companion.toKotlin as datasetPropertyKeyResponseToKotlin
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Dataset].
 */
@PulumiTagMarker
public class DatasetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatasetArgs = DatasetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatasetArgsBuilder.() -> Unit) {
        val builder = DatasetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Dataset {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsdataprocessor.Dataset(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Dataset(builtJavaResource)
    }
}

/**
 * A Dataset resource belonging to an Instance resource.
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Datasets create or update - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataset = new AzureNative.IoTOperationsDataProcessor.Dataset("dataset", new()
 *     {
 *         DatasetName = "709v7-95-5-t-52oc5--s-5-5876j45wp6mf6--n-8bh--l55-r477",
 *         Description = "pakdvhh",
 *         ExtendedLocation = new AzureNative.IoTOperationsDataProcessor.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space",
 *             Type = "CustomLocation",
 *         },
 *         InstanceName = "xh--6h732-2-6-21-4513-2-597q-5412971q",
 *         Keys = null,
 *         Location = "westus",
 *         Payload = ".value",
 *         ResourceGroupName = "rgopenapi",
 *         Tags = null,
 *         Timestamp = ".timestamp",
 *         Ttl = "72h",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsdataprocessor/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsdataprocessor.NewDataset(ctx, "dataset", &iotoperationsdataprocessor.DatasetArgs{
 * 			DatasetName: pulumi.String("709v7-95-5-t-52oc5--s-5-5876j45wp6mf6--n-8bh--l55-r477"),
 * 			Description: pulumi.String("pakdvhh"),
 * 			ExtendedLocation: &iotoperationsdataprocessor.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			InstanceName:      pulumi.String("xh--6h732-2-6-21-4513-2-597q-5412971q"),
 * 			Keys:              nil,
 * 			Location:          pulumi.String("westus"),
 * 			Payload:           pulumi.String(".value"),
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			Tags:              nil,
 * 			Timestamp:         pulumi.String(".timestamp"),
 * 			Ttl:               pulumi.String("72h"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsdataprocessor.Dataset;
 * import com.pulumi.azurenative.iotoperationsdataprocessor.DatasetArgs;
 * import com.pulumi.azurenative.iotoperationsdataprocessor.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataset = new Dataset("dataset", DatasetArgs.builder()
 *             .datasetName("709v7-95-5-t-52oc5--s-5-5876j45wp6mf6--n-8bh--l55-r477")
 *             .description("pakdvhh")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space")
 *                 .type("CustomLocation")
 *                 .build())
 *             .instanceName("xh--6h732-2-6-21-4513-2-597q-5412971q")
 *             .keys()
 *             .location("westus")
 *             .payload(".value")
 *             .resourceGroupName("rgopenapi")
 *             .tags()
 *             .timestamp(".timestamp")
 *             .ttl("72h")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsdataprocessor:Dataset IoTOperationsDataProcessor-dataset-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsDataProcessor/instances/{instanceName}/datasets/{datasetName}
 * ```
 */
public class Dataset internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsdataprocessor.Dataset,
) : KotlinCustomResource(javaResource, DatasetMapper) {
    /**
     * Detailed description of the Dataset.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Edge location of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * List of keys that can be used for joining on enrich.
     */
    public val keys: Output<Map<String, DatasetPropertyKeyResponse>>?
        get() = javaResource.keys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            datasetPropertyKeyResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Path to the payload in the message. Enrich will add only the payload to the enriched message, other fields will not be kept except for in the indexes.
     */
    public val payload: Output<String>?
        get() = javaResource.payload().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Path to an RFC3339 timestamp in the message. If no path is provided, the ingestion time of the record is used for time-based joins.
     */
    public val timestamp: Output<String>?
        get() = javaResource.timestamp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Time to live for individual records.
     */
    public val ttl: Output<String>?
        get() = javaResource.ttl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DatasetMapper : ResourceMapper<Dataset> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsdataprocessor.Dataset::class == javaResource::class

    override fun map(javaResource: Resource): Dataset = Dataset(
        javaResource as
            com.pulumi.azurenative.iotoperationsdataprocessor.Dataset,
    )
}

/**
 * @see [Dataset].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Dataset].
 */
public suspend fun dataset(name: String, block: suspend DatasetResourceBuilder.() -> Unit):
    Dataset {
    val builder = DatasetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Dataset].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataset(name: String): Dataset {
    val builder = DatasetResourceBuilder()
    builder.name(name)
    return builder.build()
}
