@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BrokerDiagnosticsResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.CardinalityResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.CertManagerCertOptionsResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DiskBackedMessageBufferSettingsResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BrokerDiagnosticsResponse.Companion.toKotlin as brokerDiagnosticsResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.CardinalityResponse.Companion.toKotlin as cardinalityResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.CertManagerCertOptionsResponse.Companion.toKotlin as certManagerCertOptionsResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse.Companion.toKotlin as containerImageResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DiskBackedMessageBufferSettingsResponse.Companion.toKotlin as diskBackedMessageBufferSettingsResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin as extendedLocationPropertyResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse.Companion.toKotlin as nodeTolerationsResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Broker].
 */
@PulumiTagMarker
public class BrokerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BrokerArgs = BrokerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BrokerArgsBuilder.() -> Unit) {
        val builder = BrokerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Broker {
        val builtJavaResource = com.pulumi.azurenative.iotoperationsmq.Broker(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Broker(builtJavaResource)
    }
}

/**
 * MQ broker resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Broker_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var broker = new AzureNative.IoTOperationsMQ.Broker("broker", new()
 *     {
 *         AuthImage = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         BrokerImage = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         BrokerName = "29tAwt4A2-aH6nP",
 *         BrokerNodeTolerations = new AzureNative.IoTOperationsMQ.Inputs.NodeTolerationsArgs
 *         {
 *             Effect = "eeswvciblqmmaeesjoflyvxqbz",
 *             Key = "wbrstdwxgm",
 *             Operator = "lbegegneekwnyodtzraarivtwhmzep",
 *             Value = "sfafsjdcezdmkwibxeluukxgl",
 *         },
 *         Cardinality = new AzureNative.IoTOperationsMQ.Inputs.CardinalityArgs
 *         {
 *             BackendChain = new AzureNative.IoTOperationsMQ.Inputs.BackendChainArgs
 *             {
 *                 Partitions = 34721,
 *                 RedundancyFactor = 468,
 *                 TemporaryDiskTransferEnabled = true,
 *                 TemporaryDiskTransferHighWatermarkPercent = 79,
 *                 TemporaryDiskTransferLowWatermarkPercent = 94,
 *                 TemporaryMaxBackendMemUsagePercent = 54,
 *                 TemporaryResourceLimits = new AzureNative.IoTOperationsMQ.Inputs.TemporaryResourceLimitsConfigArgs
 *                 {
 *                     MaxInflightMessages = 33208,
 *                     MaxInflightPatches = 3410,
 *                     MaxInflightPatchesPerClient = 58933,
 *                     MaxMessageExpirySecs = 2036532516,
 *                     MaxQueuedMessages = 8083241696687839232,
 *                     MaxQueuedQos0Messages = 6545343433569253376,
 *                     MaxSessionExpirySecs = 2526293894,
 *                 },
 *                 Workers = 15754,
 *             },
 *             Frontend = new AzureNative.IoTOperationsMQ.Inputs.FrontendArgs
 *             {
 *                 Replicas = 38165,
 *                 TemporaryResourceLimits = new AzureNative.IoTOperationsMQ.Inputs.TemporaryResourceLimitsConfigArgs
 *                 {
 *                     MaxInflightMessages = 33208,
 *                     MaxInflightPatches = 3410,
 *                     MaxInflightPatchesPerClient = 58933,
 *                     MaxMessageExpirySecs = 2036532516,
 *                     MaxQueuedMessages = 8083241696687839232,
 *                     MaxQueuedQos0Messages = 6545343433569253376,
 *                     MaxSessionExpirySecs = 2526293894,
 *                 },
 *                 Workers = 38,
 *             },
 *         },
 *         Diagnostics = new AzureNative.IoTOperationsMQ.Inputs.BrokerDiagnosticsArgs
 *         {
 *             DiagnosticServiceEndpoint = "cdvelitwasofaaqhdb",
 *             EnableMetrics = true,
 *             EnableSelfCheck = true,
 *             EnableSelfTracing = true,
 *             EnableTracing = true,
 *             LogFormat = "tcivnlakxcajynypbz",
 *             LogLevel = "zdjh",
 *             MaxCellMapLifetime = 997099872515057664,
 *             MetricUpdateFrequencySeconds = 6156703238506293248,
 *             ProbeImage = "uzizubdxsgcpjwly",
 *             SelfCheckFrequencySeconds = 579622483050303872,
 *             SelfCheckTimeoutSeconds = 7847246333600883712,
 *             SelfTraceFrequencySeconds = 6527612490765174784,
 *             SpanChannelCapacity = 5533451650716961792,
 *         },
 *         DiskBackedMessageBufferSettings = new AzureNative.IoTOperationsMQ.Inputs.DiskBackedMessageBufferSettingsArgs
 *         {
 *             EphemeralVolumeClaimSpec = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimSpecArgs
 *             {
 *                 AccessModes = new[]
 *                 {
 *                     "cly",
 *                 },
 *                 DataSource = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimDataSourceArgs
 *                 {
 *                     ApiGroup = "v",
 *                     Kind = "pvzbnjebkoslzzucpaem",
 *                     Name = "bgzdfwfpdrubbbnfwzyr",
 *                 },
 *                 DataSourceRef = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimDataSourceRefArgs
 *                 {
 *                     ApiGroup = "e",
 *                     Kind = "hjbktqbtg",
 *                     Name = "losjjcujomepwhztzptrobavolc",
 *                 },
 *                 Resources = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimResourceRequirementsArgs
 *                 {
 *                     Limits = null,
 *                     Requests = null,
 *                 },
 *                 Selector = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimSpecSelectorArgs
 *                 {
 *                     MatchExpressions = new[]
 *                     {
 *                         new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimSpecSelectorMatchExpressionsArgs
 *                         {
 *                             Key = "d",
 *                             Operator = "fcfvoarytcdbtccjervsmdis",
 *                             Values = new[]
 *                             {
 *                                 "y",
 *                             },
 *                         },
 *                     },
 *                     MatchLabels = null,
 *                 },
 *                 StorageClassName = "etajfhrtgatxi",
 *                 VolumeMode = "mipdeutsgidkzpxelbrqggjheplvmx",
 *                 VolumeName = "dacuvlvuullautxjxwdctvzlmd",
 *             },
 *             MaxSize = "gnwxgqjypylz",
 *             PersistentVolumeClaimSpec = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimSpecArgs
 *             {
 *                 AccessModes = new[]
 *                 {
 *                     "cly",
 *                 },
 *                 DataSource = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimDataSourceArgs
 *                 {
 *                     ApiGroup = "v",
 *                     Kind = "pvzbnjebkoslzzucpaem",
 *                     Name = "bgzdfwfpdrubbbnfwzyr",
 *                 },
 *                 DataSourceRef = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimDataSourceRefArgs
 *                 {
 *                     ApiGroup = "e",
 *                     Kind = "hjbktqbtg",
 *                     Name = "losjjcujomepwhztzptrobavolc",
 *                 },
 *                 Resources = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimResourceRequirementsArgs
 *                 {
 *                     Limits = null,
 *                     Requests = null,
 *                 },
 *                 Selector = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimSpecSelectorArgs
 *                 {
 *                     MatchExpressions = new[]
 *                     {
 *                         new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimSpecSelectorMatchExpressionsArgs
 *                         {
 *                             Key = "d",
 *                             Operator = "fcfvoarytcdbtccjervsmdis",
 *                             Values = new[]
 *                             {
 *                                 "y",
 *                             },
 *                         },
 *                     },
 *                     MatchLabels = null,
 *                 },
 *                 StorageClassName = "etajfhrtgatxi",
 *                 VolumeMode = "mipdeutsgidkzpxelbrqggjheplvmx",
 *                 VolumeName = "dacuvlvuullautxjxwdctvzlmd",
 *             },
 *         },
 *         EncryptInternalTraffic = true,
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = AzureNative.IoTOperationsMQ.ExtendedLocationType.CustomLocation,
 *         },
 *         HealthManagerImage = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         HealthManagerNodeTolerations = new AzureNative.IoTOperationsMQ.Inputs.NodeTolerationsArgs
 *         {
 *             Effect = "eeswvciblqmmaeesjoflyvxqbz",
 *             Key = "wbrstdwxgm",
 *             Operator = "lbegegneekwnyodtzraarivtwhmzep",
 *             Value = "sfafsjdcezdmkwibxeluukxgl",
 *         },
 *         InternalCerts = new AzureNative.IoTOperationsMQ.Inputs.CertManagerCertOptionsArgs
 *         {
 *             Duration = "xjjmzq",
 *             PrivateKey = new AzureNative.IoTOperationsMQ.Inputs.CertManagerPrivateKeyArgs
 *             {
 *                 Algorithm = "wwewfsddymjefuhxzqybwvay",
 *                 RotationPolicy = "jxmpyvfneckopjiakjtous",
 *                 Size = 63427,
 *             },
 *             RenewBefore = "zkajhllevrxkfmfyzasmbllvd",
 *         },
 *         Location = "ltzfwqzs",
 *         MemoryProfile = AzureNative.IoTOperationsMQ.BrokerMemoryProfile.Tiny,
 *         Mode = AzureNative.IoTOperationsMQ.RunMode.Auto,
 *         MqName = "u229L1RZ5",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewBroker(ctx, "broker", &iotoperationsmq.BrokerArgs{
 * 			AuthImage: &iotoperationsmq.ContainerImageArgs{
 * 				PullPolicy:  pulumi.String("imfuzvqxgbdwliqnn"),
 * 				PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * 				Repository:  pulumi.String("m"),
 * 				Tag:         pulumi.String("jygfdiamhhm"),
 * 			},
 * 			BrokerImage: &iotoperationsmq.ContainerImageArgs{
 * 				PullPolicy:  pulumi.String("imfuzvqxgbdwliqnn"),
 * 				PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * 				Repository:  pulumi.String("m"),
 * 				Tag:         pulumi.String("jygfdiamhhm"),
 * 			},
 * 			BrokerName: pulumi.String("29tAwt4A2-aH6nP"),
 * 			BrokerNodeTolerations: &iotoperationsmq.NodeTolerationsArgs{
 * 				Effect:   pulumi.String("eeswvciblqmmaeesjoflyvxqbz"),
 * 				Key:      pulumi.String("wbrstdwxgm"),
 * 				Operator: pulumi.String("lbegegneekwnyodtzraarivtwhmzep"),
 * 				Value:    pulumi.String("sfafsjdcezdmkwibxeluukxgl"),
 * 			},
 * 			Cardinality: &iotoperationsmq.CardinalityArgs{
 * 				BackendChain: &iotoperationsmq.BackendChainArgs{
 * 					Partitions:                                pulumi.Int(34721),
 * 					RedundancyFactor:                          pulumi.Int(468),
 * 					TemporaryDiskTransferEnabled:              pulumi.Bool(true),
 * 					TemporaryDiskTransferHighWatermarkPercent: pulumi.Int(79),
 * 					TemporaryDiskTransferLowWatermarkPercent:  pulumi.Int(94),
 * 					TemporaryMaxBackendMemUsagePercent:        pulumi.Int(54),
 * 					TemporaryResourceLimits: &iotoperationsmq.TemporaryResourceLimitsConfigArgs{
 * 						MaxInflightMessages:         pulumi.Int(33208),
 * 						MaxInflightPatches:          pulumi.Int(3410),
 * 						MaxInflightPatchesPerClient: pulumi.Int(58933),
 * 						MaxMessageExpirySecs:        pulumi.Float64(2036532516),
 * 						MaxQueuedMessages:           pulumi.Float64(8083241696687839232),
 * 						MaxQueuedQos0Messages:       pulumi.Float64(6545343433569253376),
 * 						MaxSessionExpirySecs:        pulumi.Float64(2526293894),
 * 					},
 * 					Workers: pulumi.Int(15754),
 * 				},
 * 				Frontend: &iotoperationsmq.FrontendArgs{
 * 					Replicas: pulumi.Int(38165),
 * 					TemporaryResourceLimits: &iotoperationsmq.TemporaryResourceLimitsConfigArgs{
 * 						MaxInflightMessages:         pulumi.Int(33208),
 * 						MaxInflightPatches:          pulumi.Int(3410),
 * 						MaxInflightPatchesPerClient: pulumi.Int(58933),
 * 						MaxMessageExpirySecs:        pulumi.Float64(2036532516),
 * 						MaxQueuedMessages:           pulumi.Float64(8083241696687839232),
 * 						MaxQueuedQos0Messages:       pulumi.Float64(6545343433569253376),
 * 						MaxSessionExpirySecs:        pulumi.Float64(2526293894),
 * 					},
 * 					Workers: pulumi.Int(38),
 * 				},
 * 			},
 * 			Diagnostics: &iotoperationsmq.BrokerDiagnosticsArgs{
 * 				DiagnosticServiceEndpoint:    pulumi.String("cdvelitwasofaaqhdb"),
 * 				EnableMetrics:                pulumi.Bool(true),
 * 				EnableSelfCheck:              pulumi.Bool(true),
 * 				EnableSelfTracing:            pulumi.Bool(true),
 * 				EnableTracing:                pulumi.Bool(true),
 * 				LogFormat:                    pulumi.String("tcivnlakxcajynypbz"),
 * 				LogLevel:                     pulumi.String("zdjh"),
 * 				MaxCellMapLifetime:           pulumi.Float64(997099872515057664),
 * 				MetricUpdateFrequencySeconds: pulumi.Float64(6156703238506293248),
 * 				ProbeImage:                   pulumi.String("uzizubdxsgcpjwly"),
 * 				SelfCheckFrequencySeconds:    pulumi.Float64(579622483050303872),
 * 				SelfCheckTimeoutSeconds:      pulumi.Float64(7847246333600883712),
 * 				SelfTraceFrequencySeconds:    pulumi.Float64(6527612490765174784),
 * 				SpanChannelCapacity:          pulumi.Float64(5533451650716961792),
 * 			},
 * 			DiskBackedMessageBufferSettings: &iotoperationsmq.DiskBackedMessageBufferSettingsArgs{
 * 				EphemeralVolumeClaimSpec: &iotoperationsmq.VolumeClaimSpecArgs{
 * 					AccessModes: pulumi.StringArray{
 * 						pulumi.String("cly"),
 * 					},
 * 					DataSource: &iotoperationsmq.VolumeClaimDataSourceArgs{
 * 						ApiGroup: pulumi.String("v"),
 * 						Kind:     pulumi.String("pvzbnjebkoslzzucpaem"),
 * 						Name:     pulumi.String("bgzdfwfpdrubbbnfwzyr"),
 * 					},
 * 					DataSourceRef: &iotoperationsmq.VolumeClaimDataSourceRefArgs{
 * 						ApiGroup: pulumi.String("e"),
 * 						Kind:     pulumi.String("hjbktqbtg"),
 * 						Name:     pulumi.String("losjjcujomepwhztzptrobavolc"),
 * 					},
 * 					Resources: &iotoperationsmq.VolumeClaimResourceRequirementsArgs{
 * 						Limits:   nil,
 * 						Requests: nil,
 * 					},
 * 					Selector: &iotoperationsmq.VolumeClaimSpecSelectorArgs{
 * 						MatchExpressions: iotoperationsmq.VolumeClaimSpecSelectorMatchExpressionsArray{
 * 							&iotoperationsmq.VolumeClaimSpecSelectorMatchExpressionsArgs{
 * 								Key:      pulumi.String("d"),
 * 								Operator: pulumi.String("fcfvoarytcdbtccjervsmdis"),
 * 								Values: pulumi.StringArray{
 * 									pulumi.String("y"),
 * 								},
 * 							},
 * 						},
 * 						MatchLabels: nil,
 * 					},
 * 					StorageClassName: pulumi.String("etajfhrtgatxi"),
 * 					VolumeMode:       pulumi.String("mipdeutsgidkzpxelbrqggjheplvmx"),
 * 					VolumeName:       pulumi.String("dacuvlvuullautxjxwdctvzlmd"),
 * 				},
 * 				MaxSize: pulumi.String("gnwxgqjypylz"),
 * 				PersistentVolumeClaimSpec: &iotoperationsmq.VolumeClaimSpecArgs{
 * 					AccessModes: pulumi.StringArray{
 * 						pulumi.String("cly"),
 * 					},
 * 					DataSource: &iotoperationsmq.VolumeClaimDataSourceArgs{
 * 						ApiGroup: pulumi.String("v"),
 * 						Kind:     pulumi.String("pvzbnjebkoslzzucpaem"),
 * 						Name:     pulumi.String("bgzdfwfpdrubbbnfwzyr"),
 * 					},
 * 					DataSourceRef: &iotoperationsmq.VolumeClaimDataSourceRefArgs{
 * 						ApiGroup: pulumi.String("e"),
 * 						Kind:     pulumi.String("hjbktqbtg"),
 * 						Name:     pulumi.String("losjjcujomepwhztzptrobavolc"),
 * 					},
 * 					Resources: &iotoperationsmq.VolumeClaimResourceRequirementsArgs{
 * 						Limits:   nil,
 * 						Requests: nil,
 * 					},
 * 					Selector: &iotoperationsmq.VolumeClaimSpecSelectorArgs{
 * 						MatchExpressions: iotoperationsmq.VolumeClaimSpecSelectorMatchExpressionsArray{
 * 							&iotoperationsmq.VolumeClaimSpecSelectorMatchExpressionsArgs{
 * 								Key:      pulumi.String("d"),
 * 								Operator: pulumi.String("fcfvoarytcdbtccjervsmdis"),
 * 								Values: pulumi.StringArray{
 * 									pulumi.String("y"),
 * 								},
 * 							},
 * 						},
 * 						MatchLabels: nil,
 * 					},
 * 					StorageClassName: pulumi.String("etajfhrtgatxi"),
 * 					VolumeMode:       pulumi.String("mipdeutsgidkzpxelbrqggjheplvmx"),
 * 					VolumeName:       pulumi.String("dacuvlvuullautxjxwdctvzlmd"),
 * 				},
 * 			},
 * 			EncryptInternalTraffic: pulumi.Bool(true),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String(iotoperationsmq.ExtendedLocationTypeCustomLocation),
 * 			},
 * 			HealthManagerImage: &iotoperationsmq.ContainerImageArgs{
 * 				PullPolicy:  pulumi.String("imfuzvqxgbdwliqnn"),
 * 				PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * 				Repository:  pulumi.String("m"),
 * 				Tag:         pulumi.String("jygfdiamhhm"),
 * 			},
 * 			HealthManagerNodeTolerations: &iotoperationsmq.NodeTolerationsArgs{
 * 				Effect:   pulumi.String("eeswvciblqmmaeesjoflyvxqbz"),
 * 				Key:      pulumi.String("wbrstdwxgm"),
 * 				Operator: pulumi.String("lbegegneekwnyodtzraarivtwhmzep"),
 * 				Value:    pulumi.String("sfafsjdcezdmkwibxeluukxgl"),
 * 			},
 * 			InternalCerts: &iotoperationsmq.CertManagerCertOptionsArgs{
 * 				Duration: pulumi.String("xjjmzq"),
 * 				PrivateKey: &iotoperationsmq.CertManagerPrivateKeyArgs{
 * 					Algorithm:      pulumi.String("wwewfsddymjefuhxzqybwvay"),
 * 					RotationPolicy: pulumi.String("jxmpyvfneckopjiakjtous"),
 * 					Size:           pulumi.Int(63427),
 * 				},
 * 				RenewBefore: pulumi.String("zkajhllevrxkfmfyzasmbllvd"),
 * 			},
 * 			Location:          pulumi.String("ltzfwqzs"),
 * 			MemoryProfile:     pulumi.String(iotoperationsmq.BrokerMemoryProfileTiny),
 * 			Mode:              pulumi.String(iotoperationsmq.RunModeAuto),
 * 			MqName:            pulumi.String("u229L1RZ5"),
 * 			ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.Broker;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ContainerImageArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.NodeTolerationsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.CardinalityArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.BackendChainArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.TemporaryResourceLimitsConfigArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.FrontendArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.BrokerDiagnosticsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DiskBackedMessageBufferSettingsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimDataSourceArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimDataSourceRefArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimResourceRequirementsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecSelectorArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerCertOptionsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerPrivateKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var broker = new Broker("broker", BrokerArgs.builder()
 *             .authImage(ContainerImageArgs.builder()
 *                 .pullPolicy("imfuzvqxgbdwliqnn")
 *                 .pullSecrets("klnqimxqsrdwhcqldjvdtsrs")
 *                 .repository("m")
 *                 .tag("jygfdiamhhm")
 *                 .build())
 *             .brokerImage(ContainerImageArgs.builder()
 *                 .pullPolicy("imfuzvqxgbdwliqnn")
 *                 .pullSecrets("klnqimxqsrdwhcqldjvdtsrs")
 *                 .repository("m")
 *                 .tag("jygfdiamhhm")
 *                 .build())
 *             .brokerName("29tAwt4A2-aH6nP")
 *             .brokerNodeTolerations(NodeTolerationsArgs.builder()
 *                 .effect("eeswvciblqmmaeesjoflyvxqbz")
 *                 .key("wbrstdwxgm")
 *                 .operator("lbegegneekwnyodtzraarivtwhmzep")
 *                 .value("sfafsjdcezdmkwibxeluukxgl")
 *                 .build())
 *             .cardinality(CardinalityArgs.builder()
 *                 .backendChain(BackendChainArgs.builder()
 *                     .partitions(34721)
 *                     .redundancyFactor(468)
 *                     .temporaryDiskTransferEnabled(true)
 *                     .temporaryDiskTransferHighWatermarkPercent(79)
 *                     .temporaryDiskTransferLowWatermarkPercent(94)
 *                     .temporaryMaxBackendMemUsagePercent(54)
 *                     .temporaryResourceLimits(TemporaryResourceLimitsConfigArgs.builder()
 *                         .maxInflightMessages(33208)
 *                         .maxInflightPatches(3410)
 *                         .maxInflightPatchesPerClient(58933)
 *                         .maxMessageExpirySecs(2036532516)
 *                         .maxQueuedMessages(8083241696687839232)
 *                         .maxQueuedQos0Messages(6545343433569253376)
 *                         .maxSessionExpirySecs(2526293894)
 *                         .build())
 *                     .workers(15754)
 *                     .build())
 *                 .frontend(FrontendArgs.builder()
 *                     .replicas(38165)
 *                     .temporaryResourceLimits(TemporaryResourceLimitsConfigArgs.builder()
 *                         .maxInflightMessages(33208)
 *                         .maxInflightPatches(3410)
 *                         .maxInflightPatchesPerClient(58933)
 *                         .maxMessageExpirySecs(2036532516)
 *                         .maxQueuedMessages(8083241696687839232)
 *                         .maxQueuedQos0Messages(6545343433569253376)
 *                         .maxSessionExpirySecs(2526293894)
 *                         .build())
 *                     .workers(38)
 *                     .build())
 *                 .build())
 *             .diagnostics(BrokerDiagnosticsArgs.builder()
 *                 .diagnosticServiceEndpoint("cdvelitwasofaaqhdb")
 *                 .enableMetrics(true)
 *                 .enableSelfCheck(true)
 *                 .enableSelfTracing(true)
 *                 .enableTracing(true)
 *                 .logFormat("tcivnlakxcajynypbz")
 *                 .logLevel("zdjh")
 *                 .maxCellMapLifetime(997099872515057664)
 *                 .metricUpdateFrequencySeconds(6156703238506293248)
 *                 .probeImage("uzizubdxsgcpjwly")
 *                 .selfCheckFrequencySeconds(579622483050303872)
 *                 .selfCheckTimeoutSeconds(7847246333600883712)
 *                 .selfTraceFrequencySeconds(6527612490765174784)
 *                 .spanChannelCapacity(5533451650716961792)
 *                 .build())
 *             .diskBackedMessageBufferSettings(DiskBackedMessageBufferSettingsArgs.builder()
 *                 .ephemeralVolumeClaimSpec(VolumeClaimSpecArgs.builder()
 *                     .accessModes("cly")
 *                     .dataSource(VolumeClaimDataSourceArgs.builder()
 *                         .apiGroup("v")
 *                         .kind("pvzbnjebkoslzzucpaem")
 *                         .name("bgzdfwfpdrubbbnfwzyr")
 *                         .build())
 *                     .dataSourceRef(VolumeClaimDataSourceRefArgs.builder()
 *                         .apiGroup("e")
 *                         .kind("hjbktqbtg")
 *                         .name("losjjcujomepwhztzptrobavolc")
 *                         .build())
 *                     .resources(VolumeClaimResourceRequirementsArgs.builder()
 *                         .limits()
 *                         .requests()
 *                         .build())
 *                     .selector(VolumeClaimSpecSelectorArgs.builder()
 *                         .matchExpressions(VolumeClaimSpecSelectorMatchExpressionsArgs.builder()
 *                             .key("d")
 *                             .operator("fcfvoarytcdbtccjervsmdis")
 *                             .values("y")
 *                             .build())
 *                         .matchLabels()
 *                         .build())
 *                     .storageClassName("etajfhrtgatxi")
 *                     .volumeMode("mipdeutsgidkzpxelbrqggjheplvmx")
 *                     .volumeName("dacuvlvuullautxjxwdctvzlmd")
 *                     .build())
 *                 .maxSize("gnwxgqjypylz")
 *                 .persistentVolumeClaimSpec(VolumeClaimSpecArgs.builder()
 *                     .accessModes("cly")
 *                     .dataSource(VolumeClaimDataSourceArgs.builder()
 *                         .apiGroup("v")
 *                         .kind("pvzbnjebkoslzzucpaem")
 *                         .name("bgzdfwfpdrubbbnfwzyr")
 *                         .build())
 *                     .dataSourceRef(VolumeClaimDataSourceRefArgs.builder()
 *                         .apiGroup("e")
 *                         .kind("hjbktqbtg")
 *                         .name("losjjcujomepwhztzptrobavolc")
 *                         .build())
 *                     .resources(VolumeClaimResourceRequirementsArgs.builder()
 *                         .limits()
 *                         .requests()
 *                         .build())
 *                     .selector(VolumeClaimSpecSelectorArgs.builder()
 *                         .matchExpressions(VolumeClaimSpecSelectorMatchExpressionsArgs.builder()
 *                             .key("d")
 *                             .operator("fcfvoarytcdbtccjervsmdis")
 *                             .values("y")
 *                             .build())
 *                         .matchLabels()
 *                         .build())
 *                     .storageClassName("etajfhrtgatxi")
 *                     .volumeMode("mipdeutsgidkzpxelbrqggjheplvmx")
 *                     .volumeName("dacuvlvuullautxjxwdctvzlmd")
 *                     .build())
 *                 .build())
 *             .encryptInternalTraffic(true)
 *             .extendedLocation(ExtendedLocationPropertyArgs.builder()
 *                 .name("an")
 *                 .type("CustomLocation")
 *                 .build())
 *             .healthManagerImage(ContainerImageArgs.builder()
 *                 .pullPolicy("imfuzvqxgbdwliqnn")
 *                 .pullSecrets("klnqimxqsrdwhcqldjvdtsrs")
 *                 .repository("m")
 *                 .tag("jygfdiamhhm")
 *                 .build())
 *             .healthManagerNodeTolerations(NodeTolerationsArgs.builder()
 *                 .effect("eeswvciblqmmaeesjoflyvxqbz")
 *                 .key("wbrstdwxgm")
 *                 .operator("lbegegneekwnyodtzraarivtwhmzep")
 *                 .value("sfafsjdcezdmkwibxeluukxgl")
 *                 .build())
 *             .internalCerts(CertManagerCertOptionsArgs.builder()
 *                 .duration("xjjmzq")
 *                 .privateKey(CertManagerPrivateKeyArgs.builder()
 *                     .algorithm("wwewfsddymjefuhxzqybwvay")
 *                     .rotationPolicy("jxmpyvfneckopjiakjtous")
 *                     .size(63427)
 *                     .build())
 *                 .renewBefore("zkajhllevrxkfmfyzasmbllvd")
 *                 .build())
 *             .location("ltzfwqzs")
 *             .memoryProfile("tiny")
 *             .mode("auto")
 *             .mqName("u229L1RZ5")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:Broker blyxqmvmwlzftkvi /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/broker/{brokerName}
 * ```
 */
public class Broker internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsmq.Broker,
) : KotlinCustomResource(javaResource, BrokerMapper) {
    /**
     * The details of Authentication Docker Image.
     */
    public val authImage: Output<ContainerImageResponse>
        get() = javaResource.authImage().applyValue({ args0 ->
            args0.let({ args0 ->
                containerImageResponseToKotlin(args0)
            })
        })

    /**
     * The details of Broker Docker Image.
     */
    public val brokerImage: Output<ContainerImageResponse>
        get() = javaResource.brokerImage().applyValue({ args0 ->
            args0.let({ args0 ->
                containerImageResponseToKotlin(args0)
            })
        })

    /**
     * The details of Node Tolerations for Broker Pods.
     */
    public val brokerNodeTolerations: Output<NodeTolerationsResponse>?
        get() = javaResource.brokerNodeTolerations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nodeTolerationsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The cardinality details of the broker.
     */
    public val cardinality: Output<CardinalityResponse>?
        get() = javaResource.cardinality().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    cardinalityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The diagnostic details of the broker deployment.
     */
    public val diagnostics: Output<BrokerDiagnosticsResponse>?
        get() = javaResource.diagnostics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    brokerDiagnosticsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The settings of the disk-backed message buffer.
     */
    public val diskBackedMessageBufferSettings: Output<DiskBackedMessageBufferSettingsResponse>?
        get() = javaResource.diskBackedMessageBufferSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    diskBackedMessageBufferSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The setting to enable or disable encryption of internal Traffic.
     */
    public val encryptInternalTraffic: Output<Boolean>?
        get() = javaResource.encryptInternalTraffic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Extended Location
     */
    public val extendedLocation: Output<ExtendedLocationPropertyResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationPropertyResponseToKotlin(args0)
            })
        })

    /**
     * The details of Health Manager Docker Image.
     */
    public val healthManagerImage: Output<ContainerImageResponse>
        get() = javaResource.healthManagerImage().applyValue({ args0 ->
            args0.let({ args0 ->
                containerImageResponseToKotlin(args0)
            })
        })

    /**
     * The details of Node Tolerations for Health Manager Pods.
     */
    public val healthManagerNodeTolerations: Output<NodeTolerationsResponse>?
        get() = javaResource.healthManagerNodeTolerations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nodeTolerationsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Details of the internal CA cert that will be used to secure communication between pods.
     */
    public val internalCerts: Output<CertManagerCertOptionsResponse>?
        get() = javaResource.internalCerts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> certManagerCertOptionsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Memory profile of broker.
     */
    public val memoryProfile: Output<String>?
        get() = javaResource.memoryProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Running Mode of the Broker Deployment.
     */
    public val mode: Output<String>
        get() = javaResource.mode().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BrokerMapper : ResourceMapper<Broker> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsmq.Broker::class == javaResource::class

    override fun map(javaResource: Resource): Broker = Broker(
        javaResource as
            com.pulumi.azurenative.iotoperationsmq.Broker,
    )
}

/**
 * @see [Broker].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Broker].
 */
public suspend fun broker(name: String, block: suspend BrokerResourceBuilder.() -> Unit): Broker {
    val builder = BrokerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Broker].
 * @param name The _unique_ name of the resulting resource.
 */
public fun broker(name: String): Broker {
    val builder = BrokerResourceBuilder()
    builder.name(name)
    return builder.build()
}
