@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.AuthorizationConfigResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.AuthorizationConfigResponse.Companion.toKotlin as authorizationConfigResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin as extendedLocationPropertyResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BrokerAuthorization].
 */
@PulumiTagMarker
public class BrokerAuthorizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BrokerAuthorizationArgs = BrokerAuthorizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BrokerAuthorizationArgsBuilder.() -> Unit) {
        val builder = BrokerAuthorizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BrokerAuthorization {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsmq.BrokerAuthorization(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BrokerAuthorization(builtJavaResource)
    }
}

/**
 * MQ broker/authorization resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### BrokerAuthorization_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var brokerAuthorization = new AzureNative.IoTOperationsMQ.BrokerAuthorization("brokerAuthorization", new()
 *     {
 *         AuthorizationName = "C15G",
 *         AuthorizationPolicies = new AzureNative.IoTOperationsMQ.Inputs.AuthorizationConfigArgs
 *         {
 *             EnableCache = true,
 *             Rules = new[]
 *             {
 *                 new AzureNative.IoTOperationsMQ.Inputs.AuthorizationBasicRuleArgs
 *                 {
 *                     BrokerResources = new[]
 *                     {
 *                         new AzureNative.IoTOperationsMQ.Inputs.ResourceInfoDefinitionArgs
 *                         {
 *                             Method = AzureNative.IoTOperationsMQ.ResourceInfoDefinitionMethods.Connect,
 *                             Topics = new[]
 *                             {
 *                                 "v",
 *                             },
 *                         },
 *                     },
 *                     Principals = new AzureNative.IoTOperationsMQ.Inputs.PrincipalDefinitionArgs
 *                     {
 *                         Attributes = new[]
 *                         {
 *                             null,
 *                         },
 *                         Clientids = new[]
 *                         {
 *                             "smrfzvniq",
 *                         },
 *                         Usernames = new[]
 *                         {
 *                             "jtwwmsrzriat",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         BrokerName = "7E0-tXS-6u1h-Vx396----",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = AzureNative.IoTOperationsMQ.ExtendedLocationType.CustomLocation,
 *         },
 *         ListenerRef = new[]
 *         {
 *             "mxgpbyb",
 *         },
 *         Location = "bvgohixie",
 *         MqName = "Zz22-b2VC-9",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewBrokerAuthorization(ctx, "brokerAuthorization", &iotoperationsmq.BrokerAuthorizationArgs{
 * 			AuthorizationName: pulumi.String("C15G"),
 * 			AuthorizationPolicies: &iotoperationsmq.AuthorizationConfigArgs{
 * 				EnableCache: pulumi.Bool(true),
 * 				Rules: iotoperationsmq.AuthorizationBasicRuleArray{
 * 					&iotoperationsmq.AuthorizationBasicRuleArgs{
 * 						BrokerResources: iotoperationsmq.ResourceInfoDefinitionArray{
 * 							&iotoperationsmq.ResourceInfoDefinitionArgs{
 * 								Method: pulumi.String(iotoperationsmq.ResourceInfoDefinitionMethodsConnect),
 * 								Topics: pulumi.StringArray{
 * 									pulumi.String("v"),
 * 								},
 * 							},
 * 						},
 * 						Principals: &iotoperationsmq.PrincipalDefinitionArgs{
 * 							Attributes: pulumi.StringMapArray{
 * 								nil,
 * 							},
 * 							Clientids: pulumi.StringArray{
 * 								pulumi.String("smrfzvniq"),
 * 							},
 * 							Usernames: pulumi.StringArray{
 * 								pulumi.String("jtwwmsrzriat"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			BrokerName: pulumi.String("7E0-tXS-6u1h-Vx396----"),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String(iotoperationsmq.ExtendedLocationTypeCustomLocation),
 * 			},
 * 			ListenerRef: pulumi.StringArray{
 * 				pulumi.String("mxgpbyb"),
 * 			},
 * 			Location:          pulumi.String("bvgohixie"),
 * 			MqName:            pulumi.String("Zz22-b2VC-9"),
 * 			ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerAuthorization;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerAuthorizationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.AuthorizationConfigArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var brokerAuthorization = new BrokerAuthorization("brokerAuthorization", BrokerAuthorizationArgs.builder()
 *             .authorizationName("C15G")
 *             .authorizationPolicies(AuthorizationConfigArgs.builder()
 *                 .enableCache(true)
 *                 .rules(AuthorizationBasicRuleArgs.builder()
 *                     .brokerResources(ResourceInfoDefinitionArgs.builder()
 *                         .method("Connect")
 *                         .topics("v")
 *                         .build())
 *                     .principals(PrincipalDefinitionArgs.builder()
 *                         .attributes()
 *                         .clientids("smrfzvniq")
 *                         .usernames("jtwwmsrzriat")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .brokerName("7E0-tXS-6u1h-Vx396----")
 *             .extendedLocation(ExtendedLocationPropertyArgs.builder()
 *                 .name("an")
 *                 .type("CustomLocation")
 *                 .build())
 *             .listenerRef("mxgpbyb")
 *             .location("bvgohixie")
 *             .mqName("Zz22-b2VC-9")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:BrokerAuthorization nwffklaehhtmhqcpjauqprvykdjzzd /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/broker/{brokerName}/authorization/{authorizationName}
 * ```
 */
public class BrokerAuthorization internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsmq.BrokerAuthorization,
) : KotlinCustomResource(javaResource, BrokerAuthorizationMapper) {
    /**
     * The list of authorization policies supported by the Authorization Resource.
     */
    public val authorizationPolicies: Output<AuthorizationConfigResponse>
        get() = javaResource.authorizationPolicies().applyValue({ args0 ->
            args0.let({ args0 ->
                authorizationConfigResponseToKotlin(args0)
            })
        })

    /**
     * Extended Location
     */
    public val extendedLocation: Output<ExtendedLocationPropertyResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationPropertyResponseToKotlin(args0)
            })
        })

    /**
     * The array of listener Resources it supports.
     */
    public val listenerRef: Output<List<String>>
        get() = javaResource.listenerRef().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BrokerAuthorizationMapper : ResourceMapper<BrokerAuthorization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsmq.BrokerAuthorization::class == javaResource::class

    override fun map(javaResource: Resource): BrokerAuthorization = BrokerAuthorization(
        javaResource
            as com.pulumi.azurenative.iotoperationsmq.BrokerAuthorization,
    )
}

/**
 * @see [BrokerAuthorization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BrokerAuthorization].
 */
public suspend fun brokerAuthorization(
    name: String,
    block: suspend BrokerAuthorizationResourceBuilder.() -> Unit,
): BrokerAuthorization {
    val builder = BrokerAuthorizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BrokerAuthorization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun brokerAuthorization(name: String): BrokerAuthorization {
    val builder = BrokerAuthorizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
