@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DataLakeTargetStorageResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.LocalBrokerConnectionSpecResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse.Companion.toKotlin as containerImageResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DataLakeTargetStorageResponse.Companion.toKotlin as dataLakeTargetStorageResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin as extendedLocationPropertyResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.LocalBrokerConnectionSpecResponse.Companion.toKotlin as localBrokerConnectionSpecResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse.Companion.toKotlin as nodeTolerationsResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DataLakeConnector].
 */
@PulumiTagMarker
public class DataLakeConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataLakeConnectorArgs = DataLakeConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataLakeConnectorArgsBuilder.() -> Unit) {
        val builder = DataLakeConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataLakeConnector {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsmq.DataLakeConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataLakeConnector(builtJavaResource)
    }
}

/**
 * MQ dataLakeConnector resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### DataLakeConnector_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataLakeConnector = new AzureNative.IoTOperationsMQ.DataLakeConnector("dataLakeConnector", new()
 *     {
 *         DataLakeConnectorName = "87v4D",
 *         DatabaseFormat = AzureNative.IoTOperationsMQ.DataLakeDatabaseFormat.Delta,
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = AzureNative.IoTOperationsMQ.ExtendedLocationType.CustomLocation,
 *         },
 *         Image = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         Instances = 53467,
 *         LocalBrokerConnection = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerAuthenticationMethodsArgs
 *             {
 *                 Kubernetes = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerKubernetesAuthenticationArgs
 *                 {
 *                     SecretPath = "soukzfkouir",
 *                     ServiceAccountTokenName = "suwetviuhmhorhvsidlznnufe",
 *                 },
 *             },
 *             Endpoint = "xc",
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "rinkomfeznsfedbmllxlbmmhc",
 *             },
 *         },
 *         Location = "ewguwvlahlu",
 *         LogLevel = "ikicyoalavfmqlodnupfjayxjti",
 *         MqName = "Ox--3e65kYN0731DJ1Qg",
 *         NodeTolerations = new AzureNative.IoTOperationsMQ.Inputs.NodeTolerationsArgs
 *         {
 *             Effect = "eeswvciblqmmaeesjoflyvxqbz",
 *             Key = "wbrstdwxgm",
 *             Operator = "lbegegneekwnyodtzraarivtwhmzep",
 *             Value = "sfafsjdcezdmkwibxeluukxgl",
 *         },
 *         Protocol = AzureNative.IoTOperationsMQ.MqttProtocol.V3,
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *         Target = new AzureNative.IoTOperationsMQ.Inputs.DataLakeTargetStorageArgs
 *         {
 *             DatalakeStorage = new AzureNative.IoTOperationsMQ.Inputs.DataLakeServiceStorageArgs
 *             {
 *                 Authentication = new AzureNative.IoTOperationsMQ.Inputs.DataLakeServiceStorageAuthenticationArgs
 *                 {
 *                     AccessTokenSecretName = "cfaoxjbfbwdldqjbfczvovgooyqkl",
 *                     SystemAssignedManagedIdentity = new AzureNative.IoTOperationsMQ.Inputs.ManagedIdentityAuthenticationArgs
 *                     {
 *                         Audience = "kjderojhpehosgfcrxxbh",
 *                         ExtensionName = "cyckjqqzspleajbtkniwrfsqygjfhe",
 *                     },
 *                 },
 *                 Endpoint = "bddy",
 *             },
 *             FabricOneLake = new AzureNative.IoTOperationsMQ.Inputs.DataLakeFabricStorageArgs
 *             {
 *                 Authentication = new AzureNative.IoTOperationsMQ.Inputs.DataLakeFabricStorageAuthenticationArgs
 *                 {
 *                     SystemAssignedManagedIdentity = new AzureNative.IoTOperationsMQ.Inputs.ManagedIdentityAuthenticationArgs
 *                     {
 *                         Audience = "kjderojhpehosgfcrxxbh",
 *                         ExtensionName = "cyckjqqzspleajbtkniwrfsqygjfhe",
 *                     },
 *                 },
 *                 Endpoint = "S.fabric.microsoft.com",
 *                 FabricPath = AzureNative.IoTOperationsMQ.FabricPathType.Files,
 *                 Guids = new AzureNative.IoTOperationsMQ.Inputs.FabricGuidsArgs
 *                 {
 *                     LakehouseGuid = "grsapopwjnuzbmnxbjnawaae",
 *                     WorkspaceGuid = "iwqfplayvdkdxumpdc",
 *                 },
 *                 Names = new AzureNative.IoTOperationsMQ.Inputs.FabricNamesArgs
 *                 {
 *                     LakehouseName = "iqgqtk",
 *                     WorkspaceName = "fxvlfhfcmlhcbgpopyqfikqsryct",
 *                 },
 *             },
 *             LocalStorage = new AzureNative.IoTOperationsMQ.Inputs.DataLakeLocalStorageArgs
 *             {
 *                 VolumeName = "nmzsioldiwteljpplmftk",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewDataLakeConnector(ctx, "dataLakeConnector", &iotoperationsmq.DataLakeConnectorArgs{
 * 			DataLakeConnectorName: pulumi.String("87v4D"),
 * 			DatabaseFormat:        pulumi.String(iotoperationsmq.DataLakeDatabaseFormatDelta),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String(iotoperationsmq.ExtendedLocationTypeCustomLocation),
 * 			},
 * 			Image: &iotoperationsmq.ContainerImageArgs{
 * 				PullPolicy:  pulumi.String("imfuzvqxgbdwliqnn"),
 * 				PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * 				Repository:  pulumi.String("m"),
 * 				Tag:         pulumi.String("jygfdiamhhm"),
 * 			},
 * 			Instances: pulumi.Int(53467),
 * 			LocalBrokerConnection: &iotoperationsmq.LocalBrokerConnectionSpecArgs{
 * 				Authentication: &iotoperationsmq.LocalBrokerAuthenticationMethodsArgs{
 * 					Kubernetes: &iotoperationsmq.LocalBrokerKubernetesAuthenticationArgs{
 * 						SecretPath:              pulumi.String("soukzfkouir"),
 * 						ServiceAccountTokenName: pulumi.String("suwetviuhmhorhvsidlznnufe"),
 * 					},
 * 				},
 * 				Endpoint: pulumi.String("xc"),
 * 				Tls: &iotoperationsmq.LocalBrokerConnectionTlsArgs{
 * 					TlsEnabled:                    pulumi.Bool(true),
 * 					TrustedCaCertificateConfigMap: pulumi.String("rinkomfeznsfedbmllxlbmmhc"),
 * 				},
 * 			},
 * 			Location: pulumi.String("ewguwvlahlu"),
 * 			LogLevel: pulumi.String("ikicyoalavfmqlodnupfjayxjti"),
 * 			MqName:   pulumi.String("Ox--3e65kYN0731DJ1Qg"),
 * 			NodeTolerations: &iotoperationsmq.NodeTolerationsArgs{
 * 				Effect:   pulumi.String("eeswvciblqmmaeesjoflyvxqbz"),
 * 				Key:      pulumi.String("wbrstdwxgm"),
 * 				Operator: pulumi.String("lbegegneekwnyodtzraarivtwhmzep"),
 * 				Value:    pulumi.String("sfafsjdcezdmkwibxeluukxgl"),
 * 			},
 * 			Protocol:          pulumi.String(iotoperationsmq.MqttProtocolV3),
 * 			ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * 			Tags:              nil,
 * 			Target: &iotoperationsmq.DataLakeTargetStorageArgs{
 * 				DatalakeStorage: &iotoperationsmq.DataLakeServiceStorageArgs{
 * 					Authentication: &iotoperationsmq.DataLakeServiceStorageAuthenticationArgs{
 * 						AccessTokenSecretName: pulumi.String("cfaoxjbfbwdldqjbfczvovgooyqkl"),
 * 						SystemAssignedManagedIdentity: &iotoperationsmq.ManagedIdentityAuthenticationArgs{
 * 							Audience:      pulumi.String("kjderojhpehosgfcrxxbh"),
 * 							ExtensionName: pulumi.String("cyckjqqzspleajbtkniwrfsqygjfhe"),
 * 						},
 * 					},
 * 					Endpoint: pulumi.String("bddy"),
 * 				},
 * 				FabricOneLake: &iotoperationsmq.DataLakeFabricStorageArgs{
 * 					Authentication: &iotoperationsmq.DataLakeFabricStorageAuthenticationArgs{
 * 						SystemAssignedManagedIdentity: &iotoperationsmq.ManagedIdentityAuthenticationArgs{
 * 							Audience:      pulumi.String("kjderojhpehosgfcrxxbh"),
 * 							ExtensionName: pulumi.String("cyckjqqzspleajbtkniwrfsqygjfhe"),
 * 						},
 * 					},
 * 					Endpoint:   pulumi.String("S.fabric.microsoft.com"),
 * 					FabricPath: pulumi.String(iotoperationsmq.FabricPathTypeFiles),
 * 					Guids: &iotoperationsmq.FabricGuidsArgs{
 * 						LakehouseGuid: pulumi.String("grsapopwjnuzbmnxbjnawaae"),
 * 						WorkspaceGuid: pulumi.String("iwqfplayvdkdxumpdc"),
 * 					},
 * 					Names: &iotoperationsmq.FabricNamesArgs{
 * 						LakehouseName: pulumi.String("iqgqtk"),
 * 						WorkspaceName: pulumi.String("fxvlfhfcmlhcbgpopyqfikqsryct"),
 * 					},
 * 				},
 * 				LocalStorage: &iotoperationsmq.DataLakeLocalStorageArgs{
 * 					VolumeName: pulumi.String("nmzsioldiwteljpplmftk"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.DataLakeConnector;
 * import com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ContainerImageArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionSpecArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerAuthenticationMethodsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerKubernetesAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionTlsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.NodeTolerationsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeTargetStorageArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeServiceStorageArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeServiceStorageAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ManagedIdentityAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeFabricStorageArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeFabricStorageAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.FabricGuidsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.FabricNamesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeLocalStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataLakeConnector = new DataLakeConnector("dataLakeConnector", DataLakeConnectorArgs.builder()
 *             .dataLakeConnectorName("87v4D")
 *             .databaseFormat("delta")
 *             .extendedLocation(ExtendedLocationPropertyArgs.builder()
 *                 .name("an")
 *                 .type("CustomLocation")
 *                 .build())
 *             .image(ContainerImageArgs.builder()
 *                 .pullPolicy("imfuzvqxgbdwliqnn")
 *                 .pullSecrets("klnqimxqsrdwhcqldjvdtsrs")
 *                 .repository("m")
 *                 .tag("jygfdiamhhm")
 *                 .build())
 *             .instances(53467)
 *             .localBrokerConnection(LocalBrokerConnectionSpecArgs.builder()
 *                 .authentication(LocalBrokerAuthenticationMethodsArgs.builder()
 *                     .kubernetes(LocalBrokerKubernetesAuthenticationArgs.builder()
 *                         .secretPath("soukzfkouir")
 *                         .serviceAccountTokenName("suwetviuhmhorhvsidlznnufe")
 *                         .build())
 *                     .build())
 *                 .endpoint("xc")
 *                 .tls(LocalBrokerConnectionTlsArgs.builder()
 *                     .tlsEnabled(true)
 *                     .trustedCaCertificateConfigMap("rinkomfeznsfedbmllxlbmmhc")
 *                     .build())
 *                 .build())
 *             .location("ewguwvlahlu")
 *             .logLevel("ikicyoalavfmqlodnupfjayxjti")
 *             .mqName("Ox--3e65kYN0731DJ1Qg")
 *             .nodeTolerations(NodeTolerationsArgs.builder()
 *                 .effect("eeswvciblqmmaeesjoflyvxqbz")
 *                 .key("wbrstdwxgm")
 *                 .operator("lbegegneekwnyodtzraarivtwhmzep")
 *                 .value("sfafsjdcezdmkwibxeluukxgl")
 *                 .build())
 *             .protocol("v3")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .target(DataLakeTargetStorageArgs.builder()
 *                 .datalakeStorage(DataLakeServiceStorageArgs.builder()
 *                     .authentication(DataLakeServiceStorageAuthenticationArgs.builder()
 *                         .accessTokenSecretName("cfaoxjbfbwdldqjbfczvovgooyqkl")
 *                         .systemAssignedManagedIdentity(ManagedIdentityAuthenticationArgs.builder()
 *                             .audience("kjderojhpehosgfcrxxbh")
 *                             .extensionName("cyckjqqzspleajbtkniwrfsqygjfhe")
 *                             .build())
 *                         .build())
 *                     .endpoint("bddy")
 *                     .build())
 *                 .fabricOneLake(DataLakeFabricStorageArgs.builder()
 *                     .authentication(DataLakeFabricStorageAuthenticationArgs.builder()
 *                         .systemAssignedManagedIdentity(ManagedIdentityAuthenticationArgs.builder()
 *                             .audience("kjderojhpehosgfcrxxbh")
 *                             .extensionName("cyckjqqzspleajbtkniwrfsqygjfhe")
 *                             .build())
 *                         .build())
 *                     .endpoint("S.fabric.microsoft.com")
 *                     .fabricPath("files")
 *                     .guids(FabricGuidsArgs.builder()
 *                         .lakehouseGuid("grsapopwjnuzbmnxbjnawaae")
 *                         .workspaceGuid("iwqfplayvdkdxumpdc")
 *                         .build())
 *                     .names(FabricNamesArgs.builder()
 *                         .lakehouseName("iqgqtk")
 *                         .workspaceName("fxvlfhfcmlhcbgpopyqfikqsryct")
 *                         .build())
 *                     .build())
 *                 .localStorage(DataLakeLocalStorageArgs.builder()
 *                     .volumeName("nmzsioldiwteljpplmftk")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:DataLakeConnector yduqhtfsalzehud /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/dataLakeConnector/{dataLakeConnectorName}
 * ```
 */
public class DataLakeConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsmq.DataLakeConnector,
) : KotlinCustomResource(javaResource, DataLakeConnectorMapper) {
    /**
     * DataLake database format to use.
     */
    public val databaseFormat: Output<String>
        get() = javaResource.databaseFormat().applyValue({ args0 -> args0 })

    /**
     * Extended Location
     */
    public val extendedLocation: Output<ExtendedLocationPropertyResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationPropertyResponseToKotlin(args0)
            })
        })

    /**
     * The details of DataLakeConnector Docker Image.
     */
    public val image: Output<ContainerImageResponse>
        get() = javaResource.image().applyValue({ args0 ->
            args0.let({ args0 ->
                containerImageResponseToKotlin(args0)
            })
        })

    /**
     * The number of DataLakeConnector pods to spin up.
     */
    public val instances: Output<Int>?
        get() = javaResource.instances().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The details for connecting with Local Broker.
     */
    public val localBrokerConnection: Output<LocalBrokerConnectionSpecResponse>?
        get() = javaResource.localBrokerConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> localBrokerConnectionSpecResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The log level of the DataLake Connector instances.
     */
    public val logLevel: Output<String>?
        get() = javaResource.logLevel().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Node Tolerations for the DataLake Connector pods.
     */
    public val nodeTolerations: Output<NodeTolerationsResponse>?
        get() = javaResource.nodeTolerations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nodeTolerationsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The protocol to use for connecting with Brokers.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The protocol to use for connecting with Brokers. NOTE - Enum only storage is supported at at time.
     */
    public val target: Output<DataLakeTargetStorageResponse>
        get() = javaResource.target().applyValue({ args0 ->
            args0.let({ args0 ->
                dataLakeTargetStorageResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataLakeConnectorMapper : ResourceMapper<DataLakeConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsmq.DataLakeConnector::class == javaResource::class

    override fun map(javaResource: Resource): DataLakeConnector = DataLakeConnector(
        javaResource as
            com.pulumi.azurenative.iotoperationsmq.DataLakeConnector,
    )
}

/**
 * @see [DataLakeConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataLakeConnector].
 */
public suspend fun dataLakeConnector(
    name: String,
    block: suspend DataLakeConnectorResourceBuilder.() -> Unit,
): DataLakeConnector {
    val builder = DataLakeConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataLakeConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataLakeConnector(name: String): DataLakeConnector {
    val builder = DataLakeConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
