@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DataLakeConnectorMapResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DataLakeConnectorMapResponse.Companion.toKotlin as dataLakeConnectorMapResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin as extendedLocationPropertyResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DataLakeConnectorTopicMap].
 */
@PulumiTagMarker
public class DataLakeConnectorTopicMapResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataLakeConnectorTopicMapArgs = DataLakeConnectorTopicMapArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataLakeConnectorTopicMapArgsBuilder.() -> Unit) {
        val builder = DataLakeConnectorTopicMapArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataLakeConnectorTopicMap {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorTopicMap(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataLakeConnectorTopicMap(builtJavaResource)
    }
}

/**
 * MQ dataLakeConnector/topicMap resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### DataLakeConnectorTopicMap_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataLakeConnectorTopicMap = new AzureNative.IoTOperationsMQ.DataLakeConnectorTopicMap("dataLakeConnectorTopicMap", new()
 *     {
 *         DataLakeConnectorName = "E9gU89-1QnIG7-IP8qOQLV-",
 *         DataLakeConnectorRef = "zirczjfua",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = AzureNative.IoTOperationsMQ.ExtendedLocationType.CustomLocation,
 *         },
 *         Location = "wjmgeh",
 *         Mapping = new AzureNative.IoTOperationsMQ.Inputs.DataLakeConnectorMapArgs
 *         {
 *             AllowedLatencySecs = 25407,
 *             ClientId = "gyjduryceozwqyjdrxhrtwuw",
 *             MaxMessagesPerBatch = 1581641880,
 *             MessagePayloadType = "pwhpwzqlzlhdrozpqziipvjqrnipo",
 *             MqttSourceTopic = "mtac",
 *             Qos = 2,
 *             Table = new AzureNative.IoTOperationsMQ.Inputs.DeltaTableArgs
 *             {
 *                 Schema = new[]
 *                 {
 *                     new AzureNative.IoTOperationsMQ.Inputs.DeltaTableSchemaArgs
 *                     {
 *                         Format = AzureNative.IoTOperationsMQ.DeltaTableFormatEnum.Boolean,
 *                         Mapping = "lfnyjp",
 *                         Name = "hejqncdsueoerueffbaqix",
 *                         Optional = true,
 *                     },
 *                 },
 *                 TableName = "qyvzigmefvxwyjqksofyrstn",
 *                 TablePath = "cyrkvxsjhbhwjegmhzyixchkdnxe",
 *             },
 *         },
 *         MqName = "rc-8Z--2m-MU",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *         TopicMapName = "17-",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewDataLakeConnectorTopicMap(ctx, "dataLakeConnectorTopicMap", &iotoperationsmq.DataLakeConnectorTopicMapArgs{
 * 			DataLakeConnectorName: pulumi.String("E9gU89-1QnIG7-IP8qOQLV-"),
 * 			DataLakeConnectorRef:  pulumi.String("zirczjfua"),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String(iotoperationsmq.ExtendedLocationTypeCustomLocation),
 * 			},
 * 			Location: pulumi.String("wjmgeh"),
 * 			Mapping: &iotoperationsmq.DataLakeConnectorMapArgs{
 * 				AllowedLatencySecs:  pulumi.Int(25407),
 * 				ClientId:            pulumi.String("gyjduryceozwqyjdrxhrtwuw"),
 * 				MaxMessagesPerBatch: pulumi.Float64(1581641880),
 * 				MessagePayloadType:  pulumi.String("pwhpwzqlzlhdrozpqziipvjqrnipo"),
 * 				MqttSourceTopic:     pulumi.String("mtac"),
 * 				Qos:                 pulumi.Int(2),
 * 				Table: &iotoperationsmq.DeltaTableArgs{
 * 					Schema: iotoperationsmq.DeltaTableSchemaArray{
 * 						&iotoperationsmq.DeltaTableSchemaArgs{
 * 							Format:   pulumi.String(iotoperationsmq.DeltaTableFormatEnumBoolean),
 * 							Mapping:  pulumi.String("lfnyjp"),
 * 							Name:     pulumi.String("hejqncdsueoerueffbaqix"),
 * 							Optional: pulumi.Bool(true),
 * 						},
 * 					},
 * 					TableName: pulumi.String("qyvzigmefvxwyjqksofyrstn"),
 * 					TablePath: pulumi.String("cyrkvxsjhbhwjegmhzyixchkdnxe"),
 * 				},
 * 			},
 * 			MqName:            pulumi.String("rc-8Z--2m-MU"),
 * 			ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * 			Tags:              nil,
 * 			TopicMapName:      pulumi.String("17-"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorTopicMap;
 * import com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorTopicMapArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeConnectorMapArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DeltaTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataLakeConnectorTopicMap = new DataLakeConnectorTopicMap("dataLakeConnectorTopicMap", DataLakeConnectorTopicMapArgs.builder()
 *             .dataLakeConnectorName("E9gU89-1QnIG7-IP8qOQLV-")
 *             .dataLakeConnectorRef("zirczjfua")
 *             .extendedLocation(ExtendedLocationPropertyArgs.builder()
 *                 .name("an")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("wjmgeh")
 *             .mapping(DataLakeConnectorMapArgs.builder()
 *                 .allowedLatencySecs(25407)
 *                 .clientId("gyjduryceozwqyjdrxhrtwuw")
 *                 .maxMessagesPerBatch(1581641880)
 *                 .messagePayloadType("pwhpwzqlzlhdrozpqziipvjqrnipo")
 *                 .mqttSourceTopic("mtac")
 *                 .qos(2)
 *                 .table(DeltaTableArgs.builder()
 *                     .schema(DeltaTableSchemaArgs.builder()
 *                         .format("boolean")
 *                         .mapping("lfnyjp")
 *                         .name("hejqncdsueoerueffbaqix")
 *                         .optional(true)
 *                         .build())
 *                     .tableName("qyvzigmefvxwyjqksofyrstn")
 *                     .tablePath("cyrkvxsjhbhwjegmhzyixchkdnxe")
 *                     .build())
 *                 .build())
 *             .mqName("rc-8Z--2m-MU")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .topicMapName("17-")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:DataLakeConnectorTopicMap l /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/dataLakeConnector/{dataLakeConnectorName}/topicMap/{topicMapName}
 * ```
 */
public class DataLakeConnectorTopicMap internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorTopicMap,
) : KotlinCustomResource(javaResource, DataLakeConnectorTopicMapMapper) {
    /**
     * DataLake Connector CRD to use.
     */
    public val dataLakeConnectorRef: Output<String>
        get() = javaResource.dataLakeConnectorRef().applyValue({ args0 -> args0 })

    /**
     * Extended Location
     */
    public val extendedLocation: Output<ExtendedLocationPropertyResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationPropertyResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * TopicMap for DataLake connector.
     */
    public val mapping: Output<DataLakeConnectorMapResponse>
        get() = javaResource.mapping().applyValue({ args0 ->
            args0.let({ args0 ->
                dataLakeConnectorMapResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataLakeConnectorTopicMapMapper : ResourceMapper<DataLakeConnectorTopicMap> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorTopicMap::class == javaResource::class

    override fun map(javaResource: Resource): DataLakeConnectorTopicMap =
        DataLakeConnectorTopicMap(
            javaResource as
                com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorTopicMap,
        )
}

/**
 * @see [DataLakeConnectorTopicMap].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataLakeConnectorTopicMap].
 */
public suspend fun dataLakeConnectorTopicMap(
    name: String,
    block: suspend DataLakeConnectorTopicMapResourceBuilder.() -> Unit,
): DataLakeConnectorTopicMap {
    val builder = DataLakeConnectorTopicMapResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataLakeConnectorTopicMap].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataLakeConnectorTopicMap(name: String): DataLakeConnectorTopicMap {
    val builder = DataLakeConnectorTopicMapResourceBuilder()
    builder.name(name)
    return builder.build()
}
