@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaRemoteBrokerConnectionSpecResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.LocalBrokerConnectionSpecResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse.Companion.toKotlin as containerImageResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin as extendedLocationPropertyResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaRemoteBrokerConnectionSpecResponse.Companion.toKotlin as kafkaRemoteBrokerConnectionSpecResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.LocalBrokerConnectionSpecResponse.Companion.toKotlin as localBrokerConnectionSpecResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse.Companion.toKotlin as nodeTolerationsResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [KafkaConnector].
 */
@PulumiTagMarker
public class KafkaConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KafkaConnectorArgs = KafkaConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KafkaConnectorArgsBuilder.() -> Unit) {
        val builder = KafkaConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KafkaConnector {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsmq.KafkaConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return KafkaConnector(builtJavaResource)
    }
}

/**
 * MQ kafkaConnector resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### KafkaConnector_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kafkaConnector = new AzureNative.IoTOperationsMQ.KafkaConnector("kafkaConnector", new()
 *     {
 *         ClientIdPrefix = "yybbbeowkw",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = AzureNative.IoTOperationsMQ.ExtendedLocationType.CustomLocation,
 *         },
 *         Image = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         Instances = 55252,
 *         KafkaConnection = new AzureNative.IoTOperationsMQ.Inputs.KafkaRemoteBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.KafkaRemoteBrokerAuthenticationPropertiesArgs
 *             {
 *                 AuthType = new AzureNative.IoTOperationsMQ.Inputs.KafkaRemoteBrokerAuthenticationTypesArgs
 *                 {
 *                     Sasl = new AzureNative.IoTOperationsMQ.Inputs.SaslRemoteBrokerBasicAuthenticationArgs
 *                     {
 *                         SaslType = AzureNative.IoTOperationsMQ.KafkaSaslType.Plain,
 *                         Token = new AzureNative.IoTOperationsMQ.Inputs.SaslRemoteBrokerBasicAuthenticationTokenArgs
 *                         {
 *                             KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KafkaTokenKeyVaultPropertiesArgs
 *                             {
 *                                 Username = "fb",
 *                                 Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                                 {
 *                                     Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                                     {
 *                                         ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                                     },
 *                                     DirectoryId = "eyjniptiykzcgbzok",
 *                                     Name = "lxmwfan",
 *                                 },
 *                                 VaultSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                                 {
 *                                     Name = "bmectskddmpjxnsogwooexj",
 *                                     Version = "unjfbf",
 *                                 },
 *                             },
 *                             SecretName = "hxmqokubwldgjdtjv",
 *                         },
 *                     },
 *                     SystemAssignedManagedIdentity = new AzureNative.IoTOperationsMQ.Inputs.ManagedIdentityAuthenticationArgs
 *                     {
 *                         Audience = "kjderojhpehosgfcrxxbh",
 *                         ExtensionName = "cyckjqqzspleajbtkniwrfsqygjfhe",
 *                     },
 *                     X509 = new AzureNative.IoTOperationsMQ.Inputs.KafkaX509AuthenticationArgs
 *                     {
 *                         KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCertificatePropertiesArgs
 *                         {
 *                             Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                             {
 *                                 Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                                 {
 *                                     ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                                 },
 *                                 DirectoryId = "eyjniptiykzcgbzok",
 *                                 Name = "lxmwfan",
 *                             },
 *                             VaultCaChainSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                             {
 *                                 Name = "bmectskddmpjxnsogwooexj",
 *                                 Version = "unjfbf",
 *                             },
 *                             VaultCert = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                             {
 *                                 Name = "bmectskddmpjxnsogwooexj",
 *                                 Version = "unjfbf",
 *                             },
 *                         },
 *                         SecretName = "jlrjvqyoygynlpsekfbvyrpu",
 *                     },
 *                 },
 *                 Enabled = true,
 *             },
 *             Endpoint = "odxpssuhjkbonjmbhbebfjcah",
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.KafkaRemoteBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "kndjozglnxsgnzxq",
 *             },
 *         },
 *         KafkaConnectorName = "V5--OL8-R",
 *         LocalBrokerConnection = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerAuthenticationMethodsArgs
 *             {
 *                 Kubernetes = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerKubernetesAuthenticationArgs
 *                 {
 *                     SecretPath = "soukzfkouir",
 *                     ServiceAccountTokenName = "suwetviuhmhorhvsidlznnufe",
 *                 },
 *             },
 *             Endpoint = "xc",
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "rinkomfeznsfedbmllxlbmmhc",
 *             },
 *         },
 *         Location = "mpbupgmqssnb",
 *         LogLevel = "g",
 *         MqName = "s47Lj-S2S-Q-XY",
 *         NodeTolerations = new AzureNative.IoTOperationsMQ.Inputs.NodeTolerationsArgs
 *         {
 *             Effect = "eeswvciblqmmaeesjoflyvxqbz",
 *             Key = "wbrstdwxgm",
 *             Operator = "lbegegneekwnyodtzraarivtwhmzep",
 *             Value = "sfafsjdcezdmkwibxeluukxgl",
 *         },
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewKafkaConnector(ctx, "kafkaConnector", &iotoperationsmq.KafkaConnectorArgs{
 * 			ClientIdPrefix: pulumi.String("yybbbeowkw"),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String(iotoperationsmq.ExtendedLocationTypeCustomLocation),
 * 			},
 * 			Image: &iotoperationsmq.ContainerImageArgs{
 * 				PullPolicy:  pulumi.String("imfuzvqxgbdwliqnn"),
 * 				PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * 				Repository:  pulumi.String("m"),
 * 				Tag:         pulumi.String("jygfdiamhhm"),
 * 			},
 * 			Instances: pulumi.Int(55252),
 * 			KafkaConnection: &iotoperationsmq.KafkaRemoteBrokerConnectionSpecArgs{
 * 				Authentication: &iotoperationsmq.KafkaRemoteBrokerAuthenticationPropertiesArgs{
 * 					AuthType: &iotoperationsmq.KafkaRemoteBrokerAuthenticationTypesArgs{
 * 						Sasl: &iotoperationsmq.SaslRemoteBrokerBasicAuthenticationArgs{
 * 							SaslType: pulumi.String(iotoperationsmq.KafkaSaslTypePlain),
 * 							Token: &iotoperationsmq.SaslRemoteBrokerBasicAuthenticationTokenArgs{
 * 								KeyVault: &iotoperationsmq.KafkaTokenKeyVaultPropertiesArgs{
 * 									Username: pulumi.String("fb"),
 * 									Vault: &iotoperationsmq.KeyVaultConnectionPropertiesArgs{
 * 										Credentials: &iotoperationsmq.KeyVaultCredentialsPropertiesArgs{
 * 											ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * 										},
 * 										DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * 										Name:        pulumi.String("lxmwfan"),
 * 									},
 * 									VaultSecret: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * 										Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 										Version: pulumi.String("unjfbf"),
 * 									},
 * 								},
 * 								SecretName: pulumi.String("hxmqokubwldgjdtjv"),
 * 							},
 * 						},
 * 						SystemAssignedManagedIdentity: &iotoperationsmq.ManagedIdentityAuthenticationArgs{
 * 							Audience:      pulumi.String("kjderojhpehosgfcrxxbh"),
 * 							ExtensionName: pulumi.String("cyckjqqzspleajbtkniwrfsqygjfhe"),
 * 						},
 * 						X509: &iotoperationsmq.KafkaX509AuthenticationArgs{
 * 							KeyVault: &iotoperationsmq.KeyVaultCertificatePropertiesArgs{
 * 								Vault: &iotoperationsmq.KeyVaultConnectionPropertiesArgs{
 * 									Credentials: &iotoperationsmq.KeyVaultCredentialsPropertiesArgs{
 * 										ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * 									},
 * 									DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * 									Name:        pulumi.String("lxmwfan"),
 * 								},
 * 								VaultCaChainSecret: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * 									Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 									Version: pulumi.String("unjfbf"),
 * 								},
 * 								VaultCert: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * 									Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 									Version: pulumi.String("unjfbf"),
 * 								},
 * 							},
 * 							SecretName: pulumi.String("jlrjvqyoygynlpsekfbvyrpu"),
 * 						},
 * 					},
 * 					Enabled: pulumi.Bool(true),
 * 				},
 * 				Endpoint: pulumi.String("odxpssuhjkbonjmbhbebfjcah"),
 * 				Tls: &iotoperationsmq.KafkaRemoteBrokerConnectionTlsArgs{
 * 					TlsEnabled:                    pulumi.Bool(true),
 * 					TrustedCaCertificateConfigMap: pulumi.String("kndjozglnxsgnzxq"),
 * 				},
 * 			},
 * 			KafkaConnectorName: pulumi.String("V5--OL8-R"),
 * 			LocalBrokerConnection: &iotoperationsmq.LocalBrokerConnectionSpecArgs{
 * 				Authentication: &iotoperationsmq.LocalBrokerAuthenticationMethodsArgs{
 * 					Kubernetes: &iotoperationsmq.LocalBrokerKubernetesAuthenticationArgs{
 * 						SecretPath:              pulumi.String("soukzfkouir"),
 * 						ServiceAccountTokenName: pulumi.String("suwetviuhmhorhvsidlznnufe"),
 * 					},
 * 				},
 * 				Endpoint: pulumi.String("xc"),
 * 				Tls: &iotoperationsmq.LocalBrokerConnectionTlsArgs{
 * 					TlsEnabled:                    pulumi.Bool(true),
 * 					TrustedCaCertificateConfigMap: pulumi.String("rinkomfeznsfedbmllxlbmmhc"),
 * 				},
 * 			},
 * 			Location: pulumi.String("mpbupgmqssnb"),
 * 			LogLevel: pulumi.String("g"),
 * 			MqName:   pulumi.String("s47Lj-S2S-Q-XY"),
 * 			NodeTolerations: &iotoperationsmq.NodeTolerationsArgs{
 * 				Effect:   pulumi.String("eeswvciblqmmaeesjoflyvxqbz"),
 * 				Key:      pulumi.String("wbrstdwxgm"),
 * 				Operator: pulumi.String("lbegegneekwnyodtzraarivtwhmzep"),
 * 				Value:    pulumi.String("sfafsjdcezdmkwibxeluukxgl"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.KafkaConnector;
 * import com.pulumi.azurenative.iotoperationsmq.KafkaConnectorArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ContainerImageArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerConnectionSpecArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerAuthenticationPropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerAuthenticationTypesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.SaslRemoteBrokerBasicAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.SaslRemoteBrokerBasicAuthenticationTokenArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaTokenKeyVaultPropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultConnectionPropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCredentialsPropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultSecretObjectArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ManagedIdentityAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaX509AuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCertificatePropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerConnectionTlsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionSpecArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerAuthenticationMethodsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerKubernetesAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionTlsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.NodeTolerationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kafkaConnector = new KafkaConnector("kafkaConnector", KafkaConnectorArgs.builder()
 *             .clientIdPrefix("yybbbeowkw")
 *             .extendedLocation(ExtendedLocationPropertyArgs.builder()
 *                 .name("an")
 *                 .type("CustomLocation")
 *                 .build())
 *             .image(ContainerImageArgs.builder()
 *                 .pullPolicy("imfuzvqxgbdwliqnn")
 *                 .pullSecrets("klnqimxqsrdwhcqldjvdtsrs")
 *                 .repository("m")
 *                 .tag("jygfdiamhhm")
 *                 .build())
 *             .instances(55252)
 *             .kafkaConnection(KafkaRemoteBrokerConnectionSpecArgs.builder()
 *                 .authentication(KafkaRemoteBrokerAuthenticationPropertiesArgs.builder()
 *                     .authType(KafkaRemoteBrokerAuthenticationTypesArgs.builder()
 *                         .sasl(SaslRemoteBrokerBasicAuthenticationArgs.builder()
 *                             .saslType("plain")
 *                             .token(SaslRemoteBrokerBasicAuthenticationTokenArgs.builder()
 *                                 .keyVault(KafkaTokenKeyVaultPropertiesArgs.builder()
 *                                     .username("fb")
 *                                     .vault(KeyVaultConnectionPropertiesArgs.builder()
 *                                         .credentials(KeyVaultCredentialsPropertiesArgs.builder()
 *                                             .servicePrincipalLocalSecretName("wuimjwpbhoglbsxxa")
 *                                             .build())
 *                                         .directoryId("eyjniptiykzcgbzok")
 *                                         .name("lxmwfan")
 *                                         .build())
 *                                     .vaultSecret(KeyVaultSecretObjectArgs.builder()
 *                                         .name("bmectskddmpjxnsogwooexj")
 *                                         .version("unjfbf")
 *                                         .build())
 *                                     .build())
 *                                 .secretName("hxmqokubwldgjdtjv")
 *                                 .build())
 *                             .build())
 *                         .systemAssignedManagedIdentity(ManagedIdentityAuthenticationArgs.builder()
 *                             .audience("kjderojhpehosgfcrxxbh")
 *                             .extensionName("cyckjqqzspleajbtkniwrfsqygjfhe")
 *                             .build())
 *                         .x509(KafkaX509AuthenticationArgs.builder()
 *                             .keyVault(KeyVaultCertificatePropertiesArgs.builder()
 *                                 .vault(KeyVaultConnectionPropertiesArgs.builder()
 *                                     .credentials(KeyVaultCredentialsPropertiesArgs.builder()
 *                                         .servicePrincipalLocalSecretName("wuimjwpbhoglbsxxa")
 *                                         .build())
 *                                     .directoryId("eyjniptiykzcgbzok")
 *                                     .name("lxmwfan")
 *                                     .build())
 *                                 .vaultCaChainSecret(KeyVaultSecretObjectArgs.builder()
 *                                     .name("bmectskddmpjxnsogwooexj")
 *                                     .version("unjfbf")
 *                                     .build())
 *                                 .vaultCert(KeyVaultSecretObjectArgs.builder()
 *                                     .name("bmectskddmpjxnsogwooexj")
 *                                     .version("unjfbf")
 *                                     .build())
 *                                 .build())
 *                             .secretName("jlrjvqyoygynlpsekfbvyrpu")
 *                             .build())
 *                         .build())
 *                     .enabled(true)
 *                     .build())
 *                 .endpoint("odxpssuhjkbonjmbhbebfjcah")
 *                 .tls(KafkaRemoteBrokerConnectionTlsArgs.builder()
 *                     .tlsEnabled(true)
 *                     .trustedCaCertificateConfigMap("kndjozglnxsgnzxq")
 *                     .build())
 *                 .build())
 *             .kafkaConnectorName("V5--OL8-R")
 *             .localBrokerConnection(LocalBrokerConnectionSpecArgs.builder()
 *                 .authentication(LocalBrokerAuthenticationMethodsArgs.builder()
 *                     .kubernetes(LocalBrokerKubernetesAuthenticationArgs.builder()
 *                         .secretPath("soukzfkouir")
 *                         .serviceAccountTokenName("suwetviuhmhorhvsidlznnufe")
 *                         .build())
 *                     .build())
 *                 .endpoint("xc")
 *                 .tls(LocalBrokerConnectionTlsArgs.builder()
 *                     .tlsEnabled(true)
 *                     .trustedCaCertificateConfigMap("rinkomfeznsfedbmllxlbmmhc")
 *                     .build())
 *                 .build())
 *             .location("mpbupgmqssnb")
 *             .logLevel("g")
 *             .mqName("s47Lj-S2S-Q-XY")
 *             .nodeTolerations(NodeTolerationsArgs.builder()
 *                 .effect("eeswvciblqmmaeesjoflyvxqbz")
 *                 .key("wbrstdwxgm")
 *                 .operator("lbegegneekwnyodtzraarivtwhmzep")
 *                 .value("sfafsjdcezdmkwibxeluukxgl")
 *                 .build())
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:KafkaConnector acntmeqjezkawbphgyprhwv /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/kafkaConnector/{kafkaConnectorName}
 * ```
 */
public class KafkaConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsmq.KafkaConnector,
) : KotlinCustomResource(javaResource, KafkaConnectorMapper) {
    /**
     * The client id prefix of the dynamically generated client ids.
     */
    public val clientIdPrefix: Output<String>?
        get() = javaResource.clientIdPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Extended Location
     */
    public val extendedLocation: Output<ExtendedLocationPropertyResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationPropertyResponseToKotlin(args0)
            })
        })

    /**
     * The details of KafkaConnector Docker Image.
     */
    public val image: Output<ContainerImageResponse>?
        get() = javaResource.image().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    containerImageResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The number of KafkaConnector pods to spin up.
     */
    public val instances: Output<Int>?
        get() = javaResource.instances().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The details for connecting with Remote Kafka Broker.
     */
    public val kafkaConnection: Output<KafkaRemoteBrokerConnectionSpecResponse>
        get() = javaResource.kafkaConnection().applyValue({ args0 ->
            args0.let({ args0 ->
                kafkaRemoteBrokerConnectionSpecResponseToKotlin(args0)
            })
        })

    /**
     * The details for connecting with Local Broker.
     */
    public val localBrokerConnection: Output<LocalBrokerConnectionSpecResponse>?
        get() = javaResource.localBrokerConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> localBrokerConnectionSpecResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The log level of the Bridge Connector instances.
     */
    public val logLevel: Output<String>?
        get() = javaResource.logLevel().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Node Tolerations for the Bridge Connector pods.
     */
    public val nodeTolerations: Output<NodeTolerationsResponse>?
        get() = javaResource.nodeTolerations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nodeTolerationsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object KafkaConnectorMapper : ResourceMapper<KafkaConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsmq.KafkaConnector::class == javaResource::class

    override fun map(javaResource: Resource): KafkaConnector = KafkaConnector(
        javaResource as
            com.pulumi.azurenative.iotoperationsmq.KafkaConnector,
    )
}

/**
 * @see [KafkaConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KafkaConnector].
 */
public suspend fun kafkaConnector(
    name: String,
    block: suspend KafkaConnectorResourceBuilder.() -> Unit,
): KafkaConnector {
    val builder = KafkaConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KafkaConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kafkaConnector(name: String): KafkaConnector {
    val builder = KafkaConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
