@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.MqttBridgeConnectorArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.MqttProtocol
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ContainerImageArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ContainerImageArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.LocalBrokerConnectionSpecArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.LocalBrokerConnectionSpecArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.MqttBridgeRemoteBrokerConnectionSpecArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.MqttBridgeRemoteBrokerConnectionSpecArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.NodeTolerationsArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.NodeTolerationsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ mqttBridgeConnector resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### MqttBridgeConnector_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mqttBridgeConnector = new AzureNative.IoTOperationsMQ.MqttBridgeConnector("mqttBridgeConnector", new()
 *     {
 *         BridgeInstances = 4528,
 *         ClientIdPrefix = "yqipejvabahsexbnttiegjnh",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = AzureNative.IoTOperationsMQ.ExtendedLocationType.CustomLocation,
 *         },
 *         Image = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         LocalBrokerConnection = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerAuthenticationMethodsArgs
 *             {
 *                 Kubernetes = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerKubernetesAuthenticationArgs
 *                 {
 *                     SecretPath = "soukzfkouir",
 *                     ServiceAccountTokenName = "suwetviuhmhorhvsidlznnufe",
 *                 },
 *             },
 *             Endpoint = "xc",
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "rinkomfeznsfedbmllxlbmmhc",
 *             },
 *         },
 *         Location = "frztvxzhskx",
 *         LogLevel = "gpgijsotipdtvvkpnckuziqqv",
 *         MqName = "R8-6x-Y-L-F-21RP5-XVv",
 *         MqttBridgeConnectorName = "k1v-U4P2440C1b7T8y-G",
 *         NodeTolerations = new AzureNative.IoTOperationsMQ.Inputs.NodeTolerationsArgs
 *         {
 *             Effect = "eeswvciblqmmaeesjoflyvxqbz",
 *             Key = "wbrstdwxgm",
 *             Operator = "lbegegneekwnyodtzraarivtwhmzep",
 *             Value = "sfafsjdcezdmkwibxeluukxgl",
 *         },
 *         Protocol = AzureNative.IoTOperationsMQ.MqttProtocol.V3,
 *         RemoteBrokerConnection = new AzureNative.IoTOperationsMQ.Inputs.MqttBridgeRemoteBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.MqttBridgeRemoteBrokerAuthenticationMethodsArgs
 *             {
 *                 SystemAssignedManagedIdentity = new AzureNative.IoTOperationsMQ.Inputs.ManagedIdentityAuthenticationArgs
 *                 {
 *                     Audience = "kjderojhpehosgfcrxxbh",
 *                     ExtensionName = "cyckjqqzspleajbtkniwrfsqygjfhe",
 *                 },
 *                 X509 = new AzureNative.IoTOperationsMQ.Inputs.MqttBridgeRemoteBrokerX509AuthenticationArgs
 *                 {
 *                     KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCertificatePropertiesArgs
 *                     {
 *                         Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                         {
 *                             Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                             {
 *                                 ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                             },
 *                             DirectoryId = "eyjniptiykzcgbzok",
 *                             Name = "lxmwfan",
 *                         },
 *                         VaultCaChainSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                         {
 *                             Name = "bmectskddmpjxnsogwooexj",
 *                             Version = "unjfbf",
 *                         },
 *                         VaultCert = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                         {
 *                             Name = "bmectskddmpjxnsogwooexj",
 *                             Version = "unjfbf",
 *                         },
 *                     },
 *                     SecretName = "x",
 *                 },
 *             },
 *             Endpoint = "bshzrukafmxjgnrlhzlxbbzjdbqh",
 *             Protocol = AzureNative.IoTOperationsMQ.MqttBridgeRemoteBrokerProtocol.Mqtt,
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.MqttBridgeRemoteBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "ivtebqmclgfjx",
 *             },
 *         },
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewMqttBridgeConnector(ctx, "mqttBridgeConnector", &iotoperationsmq.MqttBridgeConnectorArgs{
 * 			BridgeInstances: pulumi.Int(4528),
 * 			ClientIdPrefix:  pulumi.String("yqipejvabahsexbnttiegjnh"),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String(iotoperationsmq.ExtendedLocationTypeCustomLocation),
 * 			},
 * 			Image: &iotoperationsmq.ContainerImageArgs{
 * 				PullPolicy:  pulumi.String("imfuzvqxgbdwliqnn"),
 * 				PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * 				Repository:  pulumi.String("m"),
 * 				Tag:         pulumi.String("jygfdiamhhm"),
 * 			},
 * 			LocalBrokerConnection: &iotoperationsmq.LocalBrokerConnectionSpecArgs{
 * 				Authentication: &iotoperationsmq.LocalBrokerAuthenticationMethodsArgs{
 * 					Kubernetes: &iotoperationsmq.LocalBrokerKubernetesAuthenticationArgs{
 * 						SecretPath:              pulumi.String("soukzfkouir"),
 * 						ServiceAccountTokenName: pulumi.String("suwetviuhmhorhvsidlznnufe"),
 * 					},
 * 				},
 * 				Endpoint: pulumi.String("xc"),
 * 				Tls: &iotoperationsmq.LocalBrokerConnectionTlsArgs{
 * 					TlsEnabled:                    pulumi.Bool(true),
 * 					TrustedCaCertificateConfigMap: pulumi.String("rinkomfeznsfedbmllxlbmmhc"),
 * 				},
 * 			},
 * 			Location:                pulumi.String("frztvxzhskx"),
 * 			LogLevel:                pulumi.String("gpgijsotipdtvvkpnckuziqqv"),
 * 			MqName:                  pulumi.String("R8-6x-Y-L-F-21RP5-XVv"),
 * 			MqttBridgeConnectorName: pulumi.String("k1v-U4P2440C1b7T8y-G"),
 * 			NodeTolerations: &iotoperationsmq.NodeTolerationsArgs{
 * 				Effect:   pulumi.String("eeswvciblqmmaeesjoflyvxqbz"),
 * 				Key:      pulumi.String("wbrstdwxgm"),
 * 				Operator: pulumi.String("lbegegneekwnyodtzraarivtwhmzep"),
 * 				Value:    pulumi.String("sfafsjdcezdmkwibxeluukxgl"),
 * 			},
 * 			Protocol: pulumi.String(iotoperationsmq.MqttProtocolV3),
 * 			RemoteBrokerConnection: &iotoperationsmq.MqttBridgeRemoteBrokerConnectionSpecArgs{
 * 				Authentication: &iotoperationsmq.MqttBridgeRemoteBrokerAuthenticationMethodsArgs{
 * 					SystemAssignedManagedIdentity: &iotoperationsmq.ManagedIdentityAuthenticationArgs{
 * 						Audience:      pulumi.String("kjderojhpehosgfcrxxbh"),
 * 						ExtensionName: pulumi.String("cyckjqqzspleajbtkniwrfsqygjfhe"),
 * 					},
 * 					X509: &iotoperationsmq.MqttBridgeRemoteBrokerX509AuthenticationArgs{
 * 						KeyVault: &iotoperationsmq.KeyVaultCertificatePropertiesArgs{
 * 							Vault: &iotoperationsmq.KeyVaultConnectionPropertiesArgs{
 * 								Credentials: &iotoperationsmq.KeyVaultCredentialsPropertiesArgs{
 * 									ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * 								},
 * 								DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * 								Name:        pulumi.String("lxmwfan"),
 * 							},
 * 							VaultCaChainSecret: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * 								Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 								Version: pulumi.String("unjfbf"),
 * 							},
 * 							VaultCert: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * 								Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 								Version: pulumi.String("unjfbf"),
 * 							},
 * 						},
 * 						SecretName: pulumi.String("x"),
 * 					},
 * 				},
 * 				Endpoint: pulumi.String("bshzrukafmxjgnrlhzlxbbzjdbqh"),
 * 				Protocol: pulumi.String(iotoperationsmq.MqttBridgeRemoteBrokerProtocolMqtt),
 * 				Tls: &iotoperationsmq.MqttBridgeRemoteBrokerConnectionTlsArgs{
 * 					TlsEnabled:                    pulumi.Bool(true),
 * 					TrustedCaCertificateConfigMap: pulumi.String("ivtebqmclgfjx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.MqttBridgeConnector;
 * import com.pulumi.azurenative.iotoperationsmq.MqttBridgeConnectorArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ContainerImageArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionSpecArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerAuthenticationMethodsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerKubernetesAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionTlsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.NodeTolerationsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerConnectionSpecArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerAuthenticationMethodsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ManagedIdentityAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerX509AuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCertificatePropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultConnectionPropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCredentialsPropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultSecretObjectArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerConnectionTlsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mqttBridgeConnector = new MqttBridgeConnector("mqttBridgeConnector", MqttBridgeConnectorArgs.builder()
 *             .bridgeInstances(4528)
 *             .clientIdPrefix("yqipejvabahsexbnttiegjnh")
 *             .extendedLocation(ExtendedLocationPropertyArgs.builder()
 *                 .name("an")
 *                 .type("CustomLocation")
 *                 .build())
 *             .image(ContainerImageArgs.builder()
 *                 .pullPolicy("imfuzvqxgbdwliqnn")
 *                 .pullSecrets("klnqimxqsrdwhcqldjvdtsrs")
 *                 .repository("m")
 *                 .tag("jygfdiamhhm")
 *                 .build())
 *             .localBrokerConnection(LocalBrokerConnectionSpecArgs.builder()
 *                 .authentication(LocalBrokerAuthenticationMethodsArgs.builder()
 *                     .kubernetes(LocalBrokerKubernetesAuthenticationArgs.builder()
 *                         .secretPath("soukzfkouir")
 *                         .serviceAccountTokenName("suwetviuhmhorhvsidlznnufe")
 *                         .build())
 *                     .build())
 *                 .endpoint("xc")
 *                 .tls(LocalBrokerConnectionTlsArgs.builder()
 *                     .tlsEnabled(true)
 *                     .trustedCaCertificateConfigMap("rinkomfeznsfedbmllxlbmmhc")
 *                     .build())
 *                 .build())
 *             .location("frztvxzhskx")
 *             .logLevel("gpgijsotipdtvvkpnckuziqqv")
 *             .mqName("R8-6x-Y-L-F-21RP5-XVv")
 *             .mqttBridgeConnectorName("k1v-U4P2440C1b7T8y-G")
 *             .nodeTolerations(NodeTolerationsArgs.builder()
 *                 .effect("eeswvciblqmmaeesjoflyvxqbz")
 *                 .key("wbrstdwxgm")
 *                 .operator("lbegegneekwnyodtzraarivtwhmzep")
 *                 .value("sfafsjdcezdmkwibxeluukxgl")
 *                 .build())
 *             .protocol("v3")
 *             .remoteBrokerConnection(MqttBridgeRemoteBrokerConnectionSpecArgs.builder()
 *                 .authentication(MqttBridgeRemoteBrokerAuthenticationMethodsArgs.builder()
 *                     .systemAssignedManagedIdentity(ManagedIdentityAuthenticationArgs.builder()
 *                         .audience("kjderojhpehosgfcrxxbh")
 *                         .extensionName("cyckjqqzspleajbtkniwrfsqygjfhe")
 *                         .build())
 *                     .x509(MqttBridgeRemoteBrokerX509AuthenticationArgs.builder()
 *                         .keyVault(KeyVaultCertificatePropertiesArgs.builder()
 *                             .vault(KeyVaultConnectionPropertiesArgs.builder()
 *                                 .credentials(KeyVaultCredentialsPropertiesArgs.builder()
 *                                     .servicePrincipalLocalSecretName("wuimjwpbhoglbsxxa")
 *                                     .build())
 *                                 .directoryId("eyjniptiykzcgbzok")
 *                                 .name("lxmwfan")
 *                                 .build())
 *                             .vaultCaChainSecret(KeyVaultSecretObjectArgs.builder()
 *                                 .name("bmectskddmpjxnsogwooexj")
 *                                 .version("unjfbf")
 *                                 .build())
 *                             .vaultCert(KeyVaultSecretObjectArgs.builder()
 *                                 .name("bmectskddmpjxnsogwooexj")
 *                                 .version("unjfbf")
 *                                 .build())
 *                             .build())
 *                         .secretName("x")
 *                         .build())
 *                     .build())
 *                 .endpoint("bshzrukafmxjgnrlhzlxbbzjdbqh")
 *                 .protocol("mqtt")
 *                 .tls(MqttBridgeRemoteBrokerConnectionTlsArgs.builder()
 *                     .tlsEnabled(true)
 *                     .trustedCaCertificateConfigMap("ivtebqmclgfjx")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:MqttBridgeConnector pjcjtrthj /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/mqttBridgeConnector/{mqttBridgeConnectorName}
 * ```
 * @property bridgeInstances The number of instances to deploy for a bridge rollout.
 * @property clientIdPrefix The client id prefix of the dynamically generated client ids.
 * @property extendedLocation Extended Location
 * @property image The details of MqttBridge Docker Image.
 * @property localBrokerConnection The details for connecting with Local Broker.
 * @property location The geo-location where the resource lives
 * @property logLevel The log level of the Bridge Connector instances.
 * @property mqName Name of MQ resource
 * @property mqttBridgeConnectorName Name of MQ mqttBridgeConnector resource
 * @property nodeTolerations The Node Tolerations for the Bridge Connector pods.
 * @property protocol The protocol to use for connecting with Brokers.
 * @property remoteBrokerConnection The details for connecting with Remote Broker.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class MqttBridgeConnectorArgs(
    public val bridgeInstances: Output<Int>? = null,
    public val clientIdPrefix: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val image: Output<ContainerImageArgs>? = null,
    public val localBrokerConnection: Output<LocalBrokerConnectionSpecArgs>? = null,
    public val location: Output<String>? = null,
    public val logLevel: Output<String>? = null,
    public val mqName: Output<String>? = null,
    public val mqttBridgeConnectorName: Output<String>? = null,
    public val nodeTolerations: Output<NodeTolerationsArgs>? = null,
    public val protocol: Output<Either<String, MqttProtocol>>? = null,
    public val remoteBrokerConnection: Output<MqttBridgeRemoteBrokerConnectionSpecArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.MqttBridgeConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.MqttBridgeConnectorArgs =
        com.pulumi.azurenative.iotoperationsmq.MqttBridgeConnectorArgs.builder()
            .bridgeInstances(bridgeInstances?.applyValue({ args0 -> args0 }))
            .clientIdPrefix(clientIdPrefix?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .image(image?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .localBrokerConnection(
                localBrokerConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .mqttBridgeConnectorName(mqttBridgeConnectorName?.applyValue({ args0 -> args0 }))
            .nodeTolerations(nodeTolerations?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .remoteBrokerConnection(
                remoteBrokerConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MqttBridgeConnectorArgs].
 */
@PulumiTagMarker
public class MqttBridgeConnectorArgsBuilder internal constructor() {
    private var bridgeInstances: Output<Int>? = null

    private var clientIdPrefix: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var image: Output<ContainerImageArgs>? = null

    private var localBrokerConnection: Output<LocalBrokerConnectionSpecArgs>? = null

    private var location: Output<String>? = null

    private var logLevel: Output<String>? = null

    private var mqName: Output<String>? = null

    private var mqttBridgeConnectorName: Output<String>? = null

    private var nodeTolerations: Output<NodeTolerationsArgs>? = null

    private var protocol: Output<Either<String, MqttProtocol>>? = null

    private var remoteBrokerConnection: Output<MqttBridgeRemoteBrokerConnectionSpecArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The number of instances to deploy for a bridge rollout.
     */
    @JvmName("kbuynlxnbsrufodl")
    public suspend fun bridgeInstances(`value`: Output<Int>) {
        this.bridgeInstances = value
    }

    /**
     * @param value The client id prefix of the dynamically generated client ids.
     */
    @JvmName("ryyhipthxwhktogk")
    public suspend fun clientIdPrefix(`value`: Output<String>) {
        this.clientIdPrefix = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("jtllwusuluftalge")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The details of MqttBridge Docker Image.
     */
    @JvmName("nnedcwpnmyvlwisl")
    public suspend fun image(`value`: Output<ContainerImageArgs>) {
        this.image = value
    }

    /**
     * @param value The details for connecting with Local Broker.
     */
    @JvmName("ddmckoscalixgxvv")
    public suspend fun localBrokerConnection(`value`: Output<LocalBrokerConnectionSpecArgs>) {
        this.localBrokerConnection = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tddngmsgamxinywe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The log level of the Bridge Connector instances.
     */
    @JvmName("mfrhwqvqhmddwyfn")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("naseeaedujfkgsxe")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value Name of MQ mqttBridgeConnector resource
     */
    @JvmName("ixwaiyprtbamwhpe")
    public suspend fun mqttBridgeConnectorName(`value`: Output<String>) {
        this.mqttBridgeConnectorName = value
    }

    /**
     * @param value The Node Tolerations for the Bridge Connector pods.
     */
    @JvmName("edmdrhstmowavtcq")
    public suspend fun nodeTolerations(`value`: Output<NodeTolerationsArgs>) {
        this.nodeTolerations = value
    }

    /**
     * @param value The protocol to use for connecting with Brokers.
     */
    @JvmName("hvxgcxbxgistjmvd")
    public suspend fun protocol(`value`: Output<Either<String, MqttProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The details for connecting with Remote Broker.
     */
    @JvmName("dfvxvvtetmbgtdxh")
    public suspend
    fun remoteBrokerConnection(`value`: Output<MqttBridgeRemoteBrokerConnectionSpecArgs>) {
        this.remoteBrokerConnection = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cykvlgvabhpkahys")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hnlshmaoxpsmvckd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The number of instances to deploy for a bridge rollout.
     */
    @JvmName("drgwxqrvapdmudbn")
    public suspend fun bridgeInstances(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bridgeInstances = mapped
    }

    /**
     * @param value The client id prefix of the dynamically generated client ids.
     */
    @JvmName("gmualtklpghomxql")
    public suspend fun clientIdPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientIdPrefix = mapped
    }

    /**
     * @param value Extended Location
     */
    @JvmName("qybqmsyspohuxbho")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("lkxyvoifxosojpny")
    public suspend
    fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The details of MqttBridge Docker Image.
     */
    @JvmName("lhshqkgmtwecxtfm")
    public suspend fun image(`value`: ContainerImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param argument The details of MqttBridge Docker Image.
     */
    @JvmName("rbfcpsioiierwbng")
    public suspend fun image(argument: suspend ContainerImageArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerImageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.image = mapped
    }

    /**
     * @param value The details for connecting with Local Broker.
     */
    @JvmName("hufvikacoyqyenev")
    public suspend fun localBrokerConnection(`value`: LocalBrokerConnectionSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localBrokerConnection = mapped
    }

    /**
     * @param argument The details for connecting with Local Broker.
     */
    @JvmName("wlwibfwlmuxrerbe")
    public suspend
    fun localBrokerConnection(argument: suspend LocalBrokerConnectionSpecArgsBuilder.() -> Unit) {
        val toBeMapped = LocalBrokerConnectionSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localBrokerConnection = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fulmjufimjxfjhyk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The log level of the Bridge Connector instances.
     */
    @JvmName("pdlwuwxomwvvkqjn")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("oumjyetrdvccxvki")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value Name of MQ mqttBridgeConnector resource
     */
    @JvmName("ixoverwnsnpiixtu")
    public suspend fun mqttBridgeConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqttBridgeConnectorName = mapped
    }

    /**
     * @param value The Node Tolerations for the Bridge Connector pods.
     */
    @JvmName("pegqqobqxmjwapfd")
    public suspend fun nodeTolerations(`value`: NodeTolerationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeTolerations = mapped
    }

    /**
     * @param argument The Node Tolerations for the Bridge Connector pods.
     */
    @JvmName("xvbgyyffqosqsebl")
    public suspend fun nodeTolerations(argument: suspend NodeTolerationsArgsBuilder.() -> Unit) {
        val toBeMapped = NodeTolerationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nodeTolerations = mapped
    }

    /**
     * @param value The protocol to use for connecting with Brokers.
     */
    @JvmName("gpjvwwalnipfbjpi")
    public suspend fun protocol(`value`: Either<String, MqttProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol to use for connecting with Brokers.
     */
    @JvmName("bpxpimxasycpthhj")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MqttProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol to use for connecting with Brokers.
     */
    @JvmName("ounjwlafpgfudnti")
    public fun protocol(`value`: MqttProtocol) {
        val toBeMapped = Either.ofRight<String, MqttProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The details for connecting with Remote Broker.
     */
    @JvmName("yxygimerebbbfvca")
    public suspend fun remoteBrokerConnection(`value`: MqttBridgeRemoteBrokerConnectionSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteBrokerConnection = mapped
    }

    /**
     * @param argument The details for connecting with Remote Broker.
     */
    @JvmName("epymqdvvhcqmcyrk")
    public suspend
    fun remoteBrokerConnection(argument: suspend MqttBridgeRemoteBrokerConnectionSpecArgsBuilder.() -> Unit) {
        val toBeMapped = MqttBridgeRemoteBrokerConnectionSpecArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.remoteBrokerConnection = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("thhusyngumjrdxqj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kyujverboqgheoao")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rpefrtawlwvmeqbe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MqttBridgeConnectorArgs = MqttBridgeConnectorArgs(
        bridgeInstances = bridgeInstances,
        clientIdPrefix = clientIdPrefix,
        extendedLocation = extendedLocation,
        image = image,
        localBrokerConnection = localBrokerConnection,
        location = location,
        logLevel = logLevel,
        mqName = mqName,
        mqttBridgeConnectorName = mqttBridgeConnectorName,
        nodeTolerations = nodeTolerations,
        protocol = protocol,
        remoteBrokerConnection = remoteBrokerConnection,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
