@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The kafka acks to use.
 */
public enum class KafkaAcks(
    public val javaValue: com.pulumi.azurenative.iotoperationsmq.enums.KafkaAcks,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.enums.KafkaAcks> {
    /**
     * Kafka acks zero.
     */
    Zero(com.pulumi.azurenative.iotoperationsmq.enums.KafkaAcks.Zero),

    /**
     * Kafka acks one.
     */
    One(com.pulumi.azurenative.iotoperationsmq.enums.KafkaAcks.One),

    /**
     * Kafka acks all.
     */
    All(com.pulumi.azurenative.iotoperationsmq.enums.KafkaAcks.All),
    ;

    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.enums.KafkaAcks = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.enums.KafkaAcks): KafkaAcks =
            KafkaAcks.values().first { it.javaValue == javaType }
    }
}
