@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeServiceStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * DataLake Service Storage details.
 * @property authentication DataLake service storage authentication details. NOTE - Enum only one method is supported.
 * @property endpoint DataLake service storage endpoint to use.
 */
public data class DataLakeServiceStorageArgs(
    public val authentication: Output<DataLakeServiceStorageAuthenticationArgs>,
    public val endpoint: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeServiceStorageArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeServiceStorageArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeServiceStorageArgs.builder()
            .authentication(authentication.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpoint(endpoint.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataLakeServiceStorageArgs].
 */
@PulumiTagMarker
public class DataLakeServiceStorageArgsBuilder internal constructor() {
    private var authentication: Output<DataLakeServiceStorageAuthenticationArgs>? = null

    private var endpoint: Output<String>? = null

    /**
     * @param value DataLake service storage authentication details. NOTE - Enum only one method is supported.
     */
    @JvmName("oxnwxsewofquwyll")
    public suspend fun authentication(`value`: Output<DataLakeServiceStorageAuthenticationArgs>) {
        this.authentication = value
    }

    /**
     * @param value DataLake service storage endpoint to use.
     */
    @JvmName("tiwwrpgeriofwabj")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value DataLake service storage authentication details. NOTE - Enum only one method is supported.
     */
    @JvmName("bcndmncvgduqoitg")
    public suspend fun authentication(`value`: DataLakeServiceStorageAuthenticationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument DataLake service storage authentication details. NOTE - Enum only one method is supported.
     */
    @JvmName("tlbgxxjkydbogmob")
    public suspend
    fun authentication(argument: suspend DataLakeServiceStorageAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = DataLakeServiceStorageAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value DataLake service storage endpoint to use.
     */
    @JvmName("bllqennhhotmhmto")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    internal fun build(): DataLakeServiceStorageArgs = DataLakeServiceStorageArgs(
        authentication = authentication ?: throw PulumiNullFieldException("authentication"),
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
    )
}
