@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeServiceStorageAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * DataLake Service Storage authentication details. NOTE - Enum only one method is supported.
 * @property accessTokenSecretName Access token secret name.
 * @property systemAssignedManagedIdentity Configuration for managed identity authentication.
 */
public data class DataLakeServiceStorageAuthenticationArgs(
    public val accessTokenSecretName: Output<String>? = null,
    public val systemAssignedManagedIdentity: Output<ManagedIdentityAuthenticationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeServiceStorageAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeServiceStorageAuthenticationArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeServiceStorageAuthenticationArgs.builder()
            .accessTokenSecretName(accessTokenSecretName?.applyValue({ args0 -> args0 }))
            .systemAssignedManagedIdentity(
                systemAssignedManagedIdentity?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [DataLakeServiceStorageAuthenticationArgs].
 */
@PulumiTagMarker
public class DataLakeServiceStorageAuthenticationArgsBuilder internal constructor() {
    private var accessTokenSecretName: Output<String>? = null

    private var systemAssignedManagedIdentity: Output<ManagedIdentityAuthenticationArgs>? = null

    /**
     * @param value Access token secret name.
     */
    @JvmName("arddbljigirrqgye")
    public suspend fun accessTokenSecretName(`value`: Output<String>) {
        this.accessTokenSecretName = value
    }

    /**
     * @param value Configuration for managed identity authentication.
     */
    @JvmName("oplmcsqpcvxrcgfx")
    public suspend
    fun systemAssignedManagedIdentity(`value`: Output<ManagedIdentityAuthenticationArgs>) {
        this.systemAssignedManagedIdentity = value
    }

    /**
     * @param value Access token secret name.
     */
    @JvmName("irbqvqcldovipdmd")
    public suspend fun accessTokenSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessTokenSecretName = mapped
    }

    /**
     * @param value Configuration for managed identity authentication.
     */
    @JvmName("yprqmkeymbpxhyta")
    public suspend fun systemAssignedManagedIdentity(`value`: ManagedIdentityAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemAssignedManagedIdentity = mapped
    }

    /**
     * @param argument Configuration for managed identity authentication.
     */
    @JvmName("rcbylqsbidltaoea")
    public suspend
    fun systemAssignedManagedIdentity(argument: suspend ManagedIdentityAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemAssignedManagedIdentity = mapped
    }

    internal fun build(): DataLakeServiceStorageAuthenticationArgs =
        DataLakeServiceStorageAuthenticationArgs(
            accessTokenSecretName = accessTokenSecretName,
            systemAssignedManagedIdentity = systemAssignedManagedIdentity,
        )
}
