@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.GetBrokerAuthorizationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationName Name of MQ broker/authorization resource
 * @property brokerName Name of MQ broker resource
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetBrokerAuthorizationPlainArgs(
    public val authorizationName: String,
    public val brokerName: String,
    public val mqName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.GetBrokerAuthorizationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.GetBrokerAuthorizationPlainArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.GetBrokerAuthorizationPlainArgs.builder()
            .authorizationName(authorizationName.let({ args0 -> args0 }))
            .brokerName(brokerName.let({ args0 -> args0 }))
            .mqName(mqName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBrokerAuthorizationPlainArgs].
 */
@PulumiTagMarker
public class GetBrokerAuthorizationPlainArgsBuilder internal constructor() {
    private var authorizationName: String? = null

    private var brokerName: String? = null

    private var mqName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of MQ broker/authorization resource
     */
    @JvmName("vbfpqdkhyhskrrvt")
    public suspend fun authorizationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationName = mapped
    }

    /**
     * @param value Name of MQ broker resource
     */
    @JvmName("kavhhfubgajxianx")
    public suspend fun brokerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.brokerName = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("qiffgannihcrktwo")
    public suspend fun mqName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tcfpcgvklyxpytvw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBrokerAuthorizationPlainArgs = GetBrokerAuthorizationPlainArgs(
        authorizationName = authorizationName ?: throw PulumiNullFieldException("authorizationName"),
        brokerName = brokerName ?: throw PulumiNullFieldException("brokerName"),
        mqName = mqName ?: throw PulumiNullFieldException("mqName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
