@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.GetDataLakeConnectorTopicMapPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataLakeConnectorName Name of MQ dataLakeConnector resource
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property topicMapName Name of MQ dataLakeConnector/topicMap resource
 */
public data class GetDataLakeConnectorTopicMapPlainArgs(
    public val dataLakeConnectorName: String,
    public val mqName: String,
    public val resourceGroupName: String,
    public val topicMapName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.GetDataLakeConnectorTopicMapPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.GetDataLakeConnectorTopicMapPlainArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.GetDataLakeConnectorTopicMapPlainArgs.builder()
            .dataLakeConnectorName(dataLakeConnectorName.let({ args0 -> args0 }))
            .mqName(mqName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .topicMapName(topicMapName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataLakeConnectorTopicMapPlainArgs].
 */
@PulumiTagMarker
public class GetDataLakeConnectorTopicMapPlainArgsBuilder internal constructor() {
    private var dataLakeConnectorName: String? = null

    private var mqName: String? = null

    private var resourceGroupName: String? = null

    private var topicMapName: String? = null

    /**
     * @param value Name of MQ dataLakeConnector resource
     */
    @JvmName("rimibhkfcfauowlr")
    public suspend fun dataLakeConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataLakeConnectorName = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("iqqocedbacsuwjil")
    public suspend fun mqName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gaixibielygyvrhc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of MQ dataLakeConnector/topicMap resource
     */
    @JvmName("lqcbnhaecjylshpq")
    public suspend fun topicMapName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicMapName = mapped
    }

    internal fun build(): GetDataLakeConnectorTopicMapPlainArgs =
        GetDataLakeConnectorTopicMapPlainArgs(
            dataLakeConnectorName = dataLakeConnectorName ?: throw
                PulumiNullFieldException("dataLakeConnectorName"),
            mqName = mqName ?: throw PulumiNullFieldException("mqName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            topicMapName = topicMapName ?: throw PulumiNullFieldException("topicMapName"),
        )
}
