@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.GetKafkaConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kafkaConnectorName Name of MQ kafkaConnector resource
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetKafkaConnectorPlainArgs(
    public val kafkaConnectorName: String,
    public val mqName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.GetKafkaConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.GetKafkaConnectorPlainArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.GetKafkaConnectorPlainArgs.builder()
            .kafkaConnectorName(kafkaConnectorName.let({ args0 -> args0 }))
            .mqName(mqName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKafkaConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetKafkaConnectorPlainArgsBuilder internal constructor() {
    private var kafkaConnectorName: String? = null

    private var mqName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of MQ kafkaConnector resource
     */
    @JvmName("uiaqcofmfsghhqhv")
    public suspend fun kafkaConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kafkaConnectorName = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("rjexfajaydfftbji")
    public suspend fun mqName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hqturkchhrtxmsnl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetKafkaConnectorPlainArgs = GetKafkaConnectorPlainArgs(
        kafkaConnectorName = kafkaConnectorName ?: throw PulumiNullFieldException("kafkaConnectorName"),
        mqName = mqName ?: throw PulumiNullFieldException("mqName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
