@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.GetMqttBridgeTopicMapPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mqName Name of MQ resource
 * @property mqttBridgeConnectorName Name of MQ mqttBridgeConnector resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property topicMapName Name of MQ mqttBridgeTopicMap resource
 */
public data class GetMqttBridgeTopicMapPlainArgs(
    public val mqName: String,
    public val mqttBridgeConnectorName: String,
    public val resourceGroupName: String,
    public val topicMapName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.GetMqttBridgeTopicMapPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.GetMqttBridgeTopicMapPlainArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.GetMqttBridgeTopicMapPlainArgs.builder()
            .mqName(mqName.let({ args0 -> args0 }))
            .mqttBridgeConnectorName(mqttBridgeConnectorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .topicMapName(topicMapName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMqttBridgeTopicMapPlainArgs].
 */
@PulumiTagMarker
public class GetMqttBridgeTopicMapPlainArgsBuilder internal constructor() {
    private var mqName: String? = null

    private var mqttBridgeConnectorName: String? = null

    private var resourceGroupName: String? = null

    private var topicMapName: String? = null

    /**
     * @param value Name of MQ resource
     */
    @JvmName("gxqcxksktoabmxhi")
    public suspend fun mqName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mqName = mapped
    }

    /**
     * @param value Name of MQ mqttBridgeConnector resource
     */
    @JvmName("vsaoxaipnlfxpnff")
    public suspend fun mqttBridgeConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mqttBridgeConnectorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rylcelsfajauisga")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of MQ mqttBridgeTopicMap resource
     */
    @JvmName("dvyltvoyvpdoclnk")
    public suspend fun topicMapName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicMapName = mapped
    }

    internal fun build(): GetMqttBridgeTopicMapPlainArgs = GetMqttBridgeTopicMapPlainArgs(
        mqName = mqName ?: throw PulumiNullFieldException("mqName"),
        mqttBridgeConnectorName = mqttBridgeConnectorName ?: throw
            PulumiNullFieldException("mqttBridgeConnectorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        topicMapName = topicMapName ?: throw PulumiNullFieldException("topicMapName"),
    )
}
