@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaTopicMapBatchingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Kafka TopicMap Batching properties
 * @property enabled The setting to enable or disable batching.
 * @property latencyMs The latency of message batching.
 * @property maxBytes The maximum bytes to send in a batch.
 * @property maxMessages The maximum messages to send in a batch.
 */
public data class KafkaTopicMapBatchingArgs(
    public val enabled: Output<Boolean>? = null,
    public val latencyMs: Output<Int>? = null,
    public val maxBytes: Output<Double>? = null,
    public val maxMessages: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KafkaTopicMapBatchingArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.KafkaTopicMapBatchingArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaTopicMapBatchingArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .latencyMs(latencyMs?.applyValue({ args0 -> args0 }))
            .maxBytes(maxBytes?.applyValue({ args0 -> args0 }))
            .maxMessages(maxMessages?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KafkaTopicMapBatchingArgs].
 */
@PulumiTagMarker
public class KafkaTopicMapBatchingArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var latencyMs: Output<Int>? = null

    private var maxBytes: Output<Double>? = null

    private var maxMessages: Output<Double>? = null

    /**
     * @param value The setting to enable or disable batching.
     */
    @JvmName("oxiycqjhanrdwkiw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The latency of message batching.
     */
    @JvmName("kmhuntjmuyxenumj")
    public suspend fun latencyMs(`value`: Output<Int>) {
        this.latencyMs = value
    }

    /**
     * @param value The maximum bytes to send in a batch.
     */
    @JvmName("xakcbpkejxljhwah")
    public suspend fun maxBytes(`value`: Output<Double>) {
        this.maxBytes = value
    }

    /**
     * @param value The maximum messages to send in a batch.
     */
    @JvmName("eelnifoskesvtpqk")
    public suspend fun maxMessages(`value`: Output<Double>) {
        this.maxMessages = value
    }

    /**
     * @param value The setting to enable or disable batching.
     */
    @JvmName("rgtkdcjytfelmuqq")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The latency of message batching.
     */
    @JvmName("ffjygdyectvubnpf")
    public suspend fun latencyMs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.latencyMs = mapped
    }

    /**
     * @param value The maximum bytes to send in a batch.
     */
    @JvmName("gqdlwaqxsvmfkwnj")
    public suspend fun maxBytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBytes = mapped
    }

    /**
     * @param value The maximum messages to send in a batch.
     */
    @JvmName("lfpgjptixppcqdul")
    public suspend fun maxMessages(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxMessages = mapped
    }

    internal fun build(): KafkaTopicMapBatchingArgs = KafkaTopicMapBatchingArgs(
        enabled = enabled,
        latencyMs = latencyMs,
        maxBytes = maxBytes,
        maxMessages = maxMessages,
    )
}
