@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCertificatePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * KeyVault certificate properties
 * @property vault KeyVault properties.
 * @property vaultCaChainSecret KeyVault CA chain secret details.
 * @property vaultCert KeyVault Cert secret details.
 */
public data class KeyVaultCertificatePropertiesArgs(
    public val vault: Output<KeyVaultConnectionPropertiesArgs>,
    public val vaultCaChainSecret: Output<KeyVaultSecretObjectArgs>? = null,
    public val vaultCert: Output<KeyVaultSecretObjectArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCertificatePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCertificatePropertiesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCertificatePropertiesArgs.builder()
            .vault(vault.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vaultCaChainSecret(
                vaultCaChainSecret?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vaultCert(vaultCert.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeyVaultCertificatePropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultCertificatePropertiesArgsBuilder internal constructor() {
    private var vault: Output<KeyVaultConnectionPropertiesArgs>? = null

    private var vaultCaChainSecret: Output<KeyVaultSecretObjectArgs>? = null

    private var vaultCert: Output<KeyVaultSecretObjectArgs>? = null

    /**
     * @param value KeyVault properties.
     */
    @JvmName("ruukjsdpwguhfjql")
    public suspend fun vault(`value`: Output<KeyVaultConnectionPropertiesArgs>) {
        this.vault = value
    }

    /**
     * @param value KeyVault CA chain secret details.
     */
    @JvmName("tutlyvlvmsqtfnhw")
    public suspend fun vaultCaChainSecret(`value`: Output<KeyVaultSecretObjectArgs>) {
        this.vaultCaChainSecret = value
    }

    /**
     * @param value KeyVault Cert secret details.
     */
    @JvmName("nfmangbtkxcbbvkb")
    public suspend fun vaultCert(`value`: Output<KeyVaultSecretObjectArgs>) {
        this.vaultCert = value
    }

    /**
     * @param value KeyVault properties.
     */
    @JvmName("dxhbdiejqssackdl")
    public suspend fun vault(`value`: KeyVaultConnectionPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vault = mapped
    }

    /**
     * @param argument KeyVault properties.
     */
    @JvmName("fufdfhdetqlmfhnb")
    public suspend fun vault(argument: suspend KeyVaultConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultConnectionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vault = mapped
    }

    /**
     * @param value KeyVault CA chain secret details.
     */
    @JvmName("ssharhlcqehkludj")
    public suspend fun vaultCaChainSecret(`value`: KeyVaultSecretObjectArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultCaChainSecret = mapped
    }

    /**
     * @param argument KeyVault CA chain secret details.
     */
    @JvmName("troggdvubrotcwlw")
    public suspend
    fun vaultCaChainSecret(argument: suspend KeyVaultSecretObjectArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretObjectArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vaultCaChainSecret = mapped
    }

    /**
     * @param value KeyVault Cert secret details.
     */
    @JvmName("bhqatfphbbgtuswi")
    public suspend fun vaultCert(`value`: KeyVaultSecretObjectArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultCert = mapped
    }

    /**
     * @param argument KeyVault Cert secret details.
     */
    @JvmName("ifxrowjcdwnojkwp")
    public suspend fun vaultCert(argument: suspend KeyVaultSecretObjectArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretObjectArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vaultCert = mapped
    }

    internal fun build(): KeyVaultCertificatePropertiesArgs = KeyVaultCertificatePropertiesArgs(
        vault = vault ?: throw PulumiNullFieldException("vault"),
        vaultCaChainSecret = vaultCaChainSecret,
        vaultCert = vaultCert ?: throw PulumiNullFieldException("vaultCert"),
    )
}
