@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultSecretPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * KeyVault secret properties
 * @property vault KeyVault properties.
 * @property vaultSecret KeyVault secret details.
 */
public data class KeyVaultSecretPropertiesArgs(
    public val vault: Output<KeyVaultConnectionPropertiesArgs>,
    public val vaultSecret: Output<KeyVaultSecretObjectArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultSecretPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultSecretPropertiesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultSecretPropertiesArgs.builder()
            .vault(vault.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vaultSecret(vaultSecret.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeyVaultSecretPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultSecretPropertiesArgsBuilder internal constructor() {
    private var vault: Output<KeyVaultConnectionPropertiesArgs>? = null

    private var vaultSecret: Output<KeyVaultSecretObjectArgs>? = null

    /**
     * @param value KeyVault properties.
     */
    @JvmName("cadmjvgpeqnustqa")
    public suspend fun vault(`value`: Output<KeyVaultConnectionPropertiesArgs>) {
        this.vault = value
    }

    /**
     * @param value KeyVault secret details.
     */
    @JvmName("kdwhxcgeycovaqvv")
    public suspend fun vaultSecret(`value`: Output<KeyVaultSecretObjectArgs>) {
        this.vaultSecret = value
    }

    /**
     * @param value KeyVault properties.
     */
    @JvmName("nxebwynqwtgruqku")
    public suspend fun vault(`value`: KeyVaultConnectionPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vault = mapped
    }

    /**
     * @param argument KeyVault properties.
     */
    @JvmName("ipedqteqidriyhqs")
    public suspend fun vault(argument: suspend KeyVaultConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultConnectionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vault = mapped
    }

    /**
     * @param value KeyVault secret details.
     */
    @JvmName("rjstogdhrcbdalhg")
    public suspend fun vaultSecret(`value`: KeyVaultSecretObjectArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultSecret = mapped
    }

    /**
     * @param argument KeyVault secret details.
     */
    @JvmName("vrhyuktrwnyjpstw")
    public suspend fun vaultSecret(argument: suspend KeyVaultSecretObjectArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretObjectArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vaultSecret = mapped
    }

    internal fun build(): KeyVaultSecretPropertiesArgs = KeyVaultSecretPropertiesArgs(
        vault = vault ?: throw PulumiNullFieldException("vault"),
        vaultSecret = vaultSecret ?: throw PulumiNullFieldException("vaultSecret"),
    )
}
