@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.SanForCertArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SANs for certificate.
 * @property dns DNS SANs.
 * @property ip IP address SANs.
 */
public data class SanForCertArgs(
    public val dns: Output<List<String>>,
    public val ip: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.SanForCertArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.SanForCertArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.SanForCertArgs.builder()
            .dns(dns.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ip(ip.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SanForCertArgs].
 */
@PulumiTagMarker
public class SanForCertArgsBuilder internal constructor() {
    private var dns: Output<List<String>>? = null

    private var ip: Output<List<String>>? = null

    /**
     * @param value DNS SANs.
     */
    @JvmName("pjoxqcgmlgkbtwfd")
    public suspend fun dns(`value`: Output<List<String>>) {
        this.dns = value
    }

    @JvmName("bthifjslidvnhsbh")
    public suspend fun dns(vararg values: Output<String>) {
        this.dns = Output.all(values.asList())
    }

    /**
     * @param values DNS SANs.
     */
    @JvmName("gynhpjytsyqvmhdk")
    public suspend fun dns(values: List<Output<String>>) {
        this.dns = Output.all(values)
    }

    /**
     * @param value IP address SANs.
     */
    @JvmName("lkbcqcnifgirtxuj")
    public suspend fun ip(`value`: Output<List<String>>) {
        this.ip = value
    }

    @JvmName("nksbcaqoijajbaxc")
    public suspend fun ip(vararg values: Output<String>) {
        this.ip = Output.all(values.asList())
    }

    /**
     * @param values IP address SANs.
     */
    @JvmName("mbupjeuplafehifx")
    public suspend fun ip(values: List<Output<String>>) {
        this.ip = Output.all(values)
    }

    /**
     * @param value DNS SANs.
     */
    @JvmName("sfivkpnfcouqwcah")
    public suspend fun dns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dns = mapped
    }

    /**
     * @param values DNS SANs.
     */
    @JvmName("riviypsotjxgejyw")
    public suspend fun dns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dns = mapped
    }

    /**
     * @param value IP address SANs.
     */
    @JvmName("bmxxbitbmrgyfqhf")
    public suspend fun ip(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param values IP address SANs.
     */
    @JvmName("aopqigoosfcpcdki")
    public suspend fun ip(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    internal fun build(): SanForCertArgs = SanForCertArgs(
        dns = dns ?: throw PulumiNullFieldException("dns"),
        ip = ip ?: throw PulumiNullFieldException("ip"),
    )
}
