@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.SaslRemoteBrokerBasicAuthenticationArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.KafkaSaslType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Kafka RemoteBrokerConnection Sasl Authentication properties.
 * @property saslType Sasl Mechanism for remote broker authentication.
 * @property token Sasl token for remote broker authentication.
 */
public data class SaslRemoteBrokerBasicAuthenticationArgs(
    public val saslType: Output<Either<String, KafkaSaslType>>,
    public val token: Output<SaslRemoteBrokerBasicAuthenticationTokenArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.SaslRemoteBrokerBasicAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.SaslRemoteBrokerBasicAuthenticationArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.SaslRemoteBrokerBasicAuthenticationArgs.builder()
            .saslType(
                saslType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .token(token.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SaslRemoteBrokerBasicAuthenticationArgs].
 */
@PulumiTagMarker
public class SaslRemoteBrokerBasicAuthenticationArgsBuilder internal constructor() {
    private var saslType: Output<Either<String, KafkaSaslType>>? = null

    private var token: Output<SaslRemoteBrokerBasicAuthenticationTokenArgs>? = null

    /**
     * @param value Sasl Mechanism for remote broker authentication.
     */
    @JvmName("yqbrcfgokxgmervn")
    public suspend fun saslType(`value`: Output<Either<String, KafkaSaslType>>) {
        this.saslType = value
    }

    /**
     * @param value Sasl token for remote broker authentication.
     */
    @JvmName("idisnaujplluhmmc")
    public suspend fun token(`value`: Output<SaslRemoteBrokerBasicAuthenticationTokenArgs>) {
        this.token = value
    }

    /**
     * @param value Sasl Mechanism for remote broker authentication.
     */
    @JvmName("spkgujyswtcnbetk")
    public suspend fun saslType(`value`: Either<String, KafkaSaslType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.saslType = mapped
    }

    /**
     * @param value Sasl Mechanism for remote broker authentication.
     */
    @JvmName("wgyvjclvjxxidljx")
    public fun saslType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KafkaSaslType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.saslType = mapped
    }

    /**
     * @param value Sasl Mechanism for remote broker authentication.
     */
    @JvmName("ywhvgatjfrhvgkwv")
    public fun saslType(`value`: KafkaSaslType) {
        val toBeMapped = Either.ofRight<String, KafkaSaslType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.saslType = mapped
    }

    /**
     * @param value Sasl token for remote broker authentication.
     */
    @JvmName("yctiqsekpcaavdxm")
    public suspend fun token(`value`: SaslRemoteBrokerBasicAuthenticationTokenArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.token = mapped
    }

    /**
     * @param argument Sasl token for remote broker authentication.
     */
    @JvmName("ryonvyxamdgikxyc")
    public suspend
    fun token(argument: suspend SaslRemoteBrokerBasicAuthenticationTokenArgsBuilder.() -> Unit) {
        val toBeMapped = SaslRemoteBrokerBasicAuthenticationTokenArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.token = mapped
    }

    internal fun build(): SaslRemoteBrokerBasicAuthenticationArgs =
        SaslRemoteBrokerBasicAuthenticationArgs(
            saslType = saslType ?: throw PulumiNullFieldException("saslType"),
            token = token ?: throw PulumiNullFieldException("token"),
        )
}
