@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecSelectorMatchExpressionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VolumeClaimSpecSelectorMatchExpressions properties
 * @property key key is the label key that the selector applies to.
 * @property operator operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.
 * @property values values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
 */
public data class VolumeClaimSpecSelectorMatchExpressionsArgs(
    public val key: Output<String>,
    public val `operator`: Output<String>,
    public val values: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecSelectorMatchExpressionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecSelectorMatchExpressionsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecSelectorMatchExpressionsArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`operator`(`operator`.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VolumeClaimSpecSelectorMatchExpressionsArgs].
 */
@PulumiTagMarker
public class VolumeClaimSpecSelectorMatchExpressionsArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `operator`: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value key is the label key that the selector applies to.
     */
    @JvmName("ksjlbdmrfjxlvkpk")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.
     */
    @JvmName("uyuwsdtijslsrcct")
    public suspend fun `operator`(`value`: Output<String>) {
        this.`operator` = value
    }

    /**
     * @param value values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
     */
    @JvmName("pryoqbfwysxuvdxp")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("tiomumvewmpoofau")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
     */
    @JvmName("yqyoolyofjwyusar")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value key is the label key that the selector applies to.
     */
    @JvmName("xunujiwvtspuvxjo")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.
     */
    @JvmName("mnsaicxclvgmaoho")
    public suspend fun `operator`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
     */
    @JvmName("fetowuldavoecegr")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
     */
    @JvmName("xlnhalyaepvbbhbx")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): VolumeClaimSpecSelectorMatchExpressionsArgs =
        VolumeClaimSpecSelectorMatchExpressionsArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
            values = values,
        )
}
