@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * BasicRules of AuthorizationConfig Polar rules are not supported
 * @property brokerResources This subfield defines the broker resources that the Basic Rule is applied on.
 * @property principals This subfield defines the identities that represent the clients.
 */
public data class AuthorizationBasicRuleResponse(
    public val brokerResources: List<ResourceInfoDefinitionResponse>,
    public val principals: PrincipalDefinitionResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.AuthorizationBasicRuleResponse):
            AuthorizationBasicRuleResponse = AuthorizationBasicRuleResponse(
            brokerResources = javaType.brokerResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ResourceInfoDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            principals = javaType.principals().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.PrincipalDefinitionResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
